% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effects.R
\name{baseline}
\alias{baseline}
\alias{intercept}
\title{baseline}
\description{
Specifies an intercept for the tie-oriented model or the sender activity
rate step of the actor-oriented model in the same manner as in
\code{\link[stats]{lm}} (see Details).
}
\details{
A baseline effect is automatically specified for the tie-oriented model and
the sender activity rate step of the actor-oriented model when the
\code{ordinal} argument in \code{\link{remstats}}, \code{\link{tomstats}},
\code{\link{aomstats}} is set to FALSE (default) and automatically removed
when this argument is set to TRUE. Alternatively, a baseline effect can be
explicitly specified by adding '1' to the equation or explicitly removed by
adding '-1' to the equation.

The baseline effect refers to the baseline tendency to interact. In the
tie-oriented model, the log-inverse of the estimated parameter translates to
the average number of observed events per time unit per dyad. In the
actor-oriented model, the log-inverse of the estimated parameter translates
to the average number of observed events per time unit per actor. The
statistic is equal to one for all dyads resp. actors in the riskset at all
timepoints.
}
\examples{
reh_tie <- remify::remify(history, model = "tie")
remstats(reh = reh_tie, tie_effects = ~1)

reh_actor <- remify::remify(history, model = "actor")
remstats(reh = reh_actor, sender_effects = ~1)
}
