% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effects.R
\name{recencyReceiveSender}
\alias{recencyReceiveSender}
\title{recencyReceiveSender}
\usage{
recencyReceiveSender(consider_type = TRUE)
}
\arguments{
\item{consider_type}{logical, indicates whether to compute the recency
separately for each event type (TRUE, default) or regardless of event types
(FALSE).}
}
\value{
List with all information required by `remstats::remstats()` to 
compute the statistic.
}
\description{
Specifies the statistic for a recency receive of sender effect in the
\code{effects} argument of \code{\link{tomstats}} or the
\code{sender_effects} argument of \code{\link{aomstats}}.
}
\details{
The recencyReceiveSender effect refers to a recency statistic similar to
what is described in Vu et al. (2017) and Mulder and Leenders (2019). For
each timepoint t, for directed dyad (i,j) the statistic is equal to 1/(the
time that has past since sender i was last active as receiver + 1). Note
that the 'recencyReceiveSender' effect is only defined for directed events.
}
\examples{
effects <- ~ recencyReceiveSender()
reh_tie <- remify::remify(history, model = "tie")
remstats(tie_effects = effects, reh = reh_tie)

reh_actor <- remify::remify(history, model = "actor")
remstats(sender_effects = effects, reh = reh_actor)

}
\seealso{
\code{\link{rrankSend}}, \code{\link{rrankReceive}},
\code{\link{recencySendSender}}, \code{\link{recencySendReceiver}},
\code{\link{recencyReceiveReceiver}} and \code{\link{recencyContinue}} for
other type of recency effects
}
