% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effects.R
\name{totaldegreeReceiver}
\alias{totaldegreeReceiver}
\title{totaldegreeReceiver}
\usage{
totaldegreeReceiver(scaling = c("none", "prop", "std"), consider_type = TRUE)
}
\arguments{
\item{scaling}{the method for scaling the degree statistic. Default is
to not scale the statistic (scaling = "none"). Alternatively,
scaling of the raw degree counts by two times the number of past events at
time t can be requested with 'prop' or standardization of the raw degree
counts per time point can be requested with 'std'.}

\item{consider_type}{logical, indicates whether to count the degrees
separately for each event type (TRUE, default) or sum degrees across
different event types (FALSE).}
}
\value{
List with all information required by `remstats::remstats()` to compute the statistic.
}
\description{
Specifies the statistic for an `totaldegreeReceiver` effect in the
tie-oriented model or the receiver choice step of the actor-oriented model.
}
\details{
A total degree of the receiver effect refers to the tendency for actors to
receive events if they have send and received more past events. The
statistic at timepoint \emph{t} for dyad \emph{(i,j)} (tie-oriented model)
or receiver \emph{j} (actor-oriented model) is equal to the number
of events send and received by actor \emph{j} before timepoint \emph{t}.
Note that the 'totaldegreeReceiver' effect is only defined for directed
events.

Optionally, a scaling method can be set with \code{scaling}. By scaling the
degree count by the total number of past events times two, the statistic
refers to the fraction of past events times two that involved actor j. At
the first time point, when no events did previously occur, it is assumed
that every actor is equally likely to receive a message and the statistic is
set equal to 1/n, where n refers to the number of actors.
}
\examples{
reh_tie <- remify::remify(history, model = "tie")
effects <- ~ totaldegreeReceiver()
remstats(reh = reh_tie, tie_effects = effects)

reh_actor <- remify::remify(history, model = "actor")
remstats(reh = reh_actor, receiver_effects = effects)

}
\seealso{
\code{\link{indegreeSender}}, \code{\link{indegreeReceiver}},
\code{\link{outdegreeSender}}, \code{\link{outdegreeReceiver}}, or
\code{\link{totaldegreeSender}} for other types of degree effects.
}
