% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPSimulation.R
\name{calcCliffdTestStatistics}
\alias{calcCliffdTestStatistics}
\title{calcCliffdTestStatistics}
\usage{
calcCliffdTestStatistics(
  d.value,
  d.variance,
  d.df = 0,
  alpha = 0.05,
  alternative = "two.sided"
)
}
\arguments{
\item{d.value}{The overall estimate of Cliff's d from a group of effect sizes to be meta-analysed}

\item{d.variance}{The estimate of the variance of the overall estimate of Cliff's d}

\item{d.df}{The total degrees of freedom for the set of effect sizes. If d.df>0, the pvalues and significance test use the t-distribution probability values. If d.df=0 (default) the pvalues and significance test use the normal distribution probability values. The confidence intervals are always based on the normal probability values.}

\item{alpha}{The significance level used to control the significance tests and calculation of confidence limits (default 0.05).}

\item{alternative}{Specifies the type of significance test and can take the values "two.sided", "less" or "greater" (default "two.sided").}
}
\value{
d.tvalue The value of the t-statistic

d.pvalue The p-value of the t-test if the parameter d.df>0, or the normal probability value if d.df=0

d.ci.lower The lower 100*(1-alpha/2)% confidence interval based on the normal probability value

d.ci.upper The upper 100*(1-alpha/2)% confidence interval based on the normal probability value

d.sig The significance of the statistical test of the d.tvalue return value at the alpha level for one sided tests and aplha/2 for two sided tests as specified by the input parameter alternative
}
\description{
This function is a helper function for meta-analysis of experiments using Cliff's d as an effect size. It returns the 100*(1-alpha/2)% confidence intervals based on the normal distribution probability values, the value of the t-test, the probability asssociated with the null hypothesis and the significance of the test. The pvalue and the significance vary according to the value of the alternative parameter and whether or not degrees of freedom are specifed.
}
\examples{
aveCliffd=mean(c(0.84,0.2,-0.04,0.44,0.76))
aveCliffdvar=sum(c(0.04,0.18,0.21,0.15,0.06))/25
df=45
calcCliffdTestStatistics(d.value=aveCliffd,d.variance=aveCliffdvar,d.df=df)
# A tibble: 1 x 5
#   d.tvalue d.pvalue d.ci.lower d.ci.upper d.sig
#      <dbl>    <dbl>      <dbl>      <dbl> <lgl>
# 1     2.75  0.00855     0.0923      0.692 TRUE
}
\author{
Barbara Kitchenham and Lech Madeyski
}
