% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_beta.R
\name{dist_beta}
\alias{dist_beta}
\title{Beta Distribution}
\usage{
dist_beta(shape1 = NULL, shape2 = NULL, ncp = NULL)
}
\arguments{
\item{shape1}{First scalar shape parameter, or \code{NULL} as a placeholder.}

\item{shape2}{Second scalar shape parameter, or \code{NULL} as a placeholder.}

\item{ncp}{Scalar non-centrality parameter, or \code{NULL} as a placeholder.}
}
\value{
A \code{BetaDistribution} object.
}
\description{
See \link[stats:Beta]{stats::Beta}
}
\details{
All parameters can be overridden with
\code{with_params = list(shape = ..., scale = ...)}.
}
\examples{
d_beta <- dist_beta(shape1 = 2, shape2 = 2, ncp = 0)
x <- d_beta$sample(100)
d_emp <- dist_empirical(x)

plot_distributions(
  empirical = d_emp,
  theoretical = d_beta,
  estimated = d_beta,
  with_params = list(
    estimated = inflate_params(
      fitdistrplus::fitdist(x, distr = "beta")$estimate
    )
  ),
  .x = seq(0, 2, length.out = 100)
)

}
\seealso{
Other Distributions: 
\code{\link{Distribution}},
\code{\link{dist_bdegp}()},
\code{\link{dist_binomial}()},
\code{\link{dist_blended}()},
\code{\link{dist_dirac}()},
\code{\link{dist_discrete}()},
\code{\link{dist_empirical}()},
\code{\link{dist_erlangmix}()},
\code{\link{dist_exponential}()},
\code{\link{dist_gamma}()},
\code{\link{dist_genpareto}()},
\code{\link{dist_lognormal}()},
\code{\link{dist_mixture}()},
\code{\link{dist_negbinomial}()},
\code{\link{dist_normal}()},
\code{\link{dist_pareto}()},
\code{\link{dist_poisson}()},
\code{\link{dist_translate}()},
\code{\link{dist_trunc}()},
\code{\link{dist_uniform}()},
\code{\link{dist_weibull}()}
}
\concept{Distributions}
