% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tf_fit.R
\name{predict.reservr_keras_model}
\alias{predict.reservr_keras_model}
\title{Predict individual distribution parameters}
\usage{
\method{predict}{reservr_keras_model}(object, data, as_matrix = FALSE, ...)
}
\arguments{
\item{object}{A compiled and trained \code{reservr_keras_model}.}

\item{data}{Input data compatible with the model.}

\item{as_matrix}{Return a parameter matrix instead of a list structure?}

\item{...}{ignored}
}
\value{
A parameter list suitable for the \code{with_params} argument of the distribution family used for the model.
Contains one set of parameters per row in \code{data}.
}
\description{
Predict individual distribution parameters
}
\examples{
if (interactive()) {
  dist <- dist_exponential()
  params <- list(rate = 1.0)
  N <- 100L
  rand_input <- runif(N)
  x <- dist$sample(N, with_params = params)

  tf_in <- keras3::layer_input(1L)
  mod <- tf_compile_model(
    inputs = list(tf_in),
    intermediate_output = tf_in,
    dist = dist,
    optimizer = keras3::optimizer_adam(),
    censoring = FALSE,
    truncation = FALSE
  )

  tf_fit <- fit(
    object = mod,
    x = k_matrix(rand_input),
    y = x,
    epochs = 10L,
    callbacks = list(
      callback_debug_dist_gradients(mod, k_matrix(rand_input), x)
    )
  )

  tf_preds <- predict(mod, data = k_matrix(rand_input))
}

}
