/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.graph.tree;

import java.util.BitSet;
import org.chocosolver.solver.constraints.graph.tree.PropArborescences;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.DirectedGraphVar;
import org.chocosolver.util.ESat;
import org.chocosolver.util.graphOperations.connectivity.StrongConnectivityFinder;
import org.chocosolver.util.objects.graphs.DirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class PropArborescence
extends PropArborescences {
    protected final int root;
    protected final BitSet visited;
    protected final int[] fifo;

    public PropArborescence(DirectedGraphVar graph, int root) {
        this(graph, root, false);
    }

    public PropArborescence(DirectedGraphVar graph, int root, boolean simple) {
        super(graph, simple);
        this.root = root;
        this.visited = new BitSet(this.n);
        this.fifo = new int[this.n];
    }

    @Override
    public void propagate(int evt) throws ContradictionException {
        this.g.enforceNode(this.root, this);
        this.explore();
        int o = this.visited.nextClearBit(0);
        while (o < this.n) {
            this.g.removeNode(o, this);
            o = this.visited.nextClearBit(o + 1);
        }
        super.propagate(evt);
    }

    @Override
    protected void reset() {
        int i;
        for (i = 0; i < this.n + 1; ++i) {
            this.connectedGraph.getSuccessorsOf(i).clear();
            this.connectedGraph.getPredecessorsOf(i).clear();
        }
        for (i = 0; i < this.n; ++i) {
            ISetIterator iSetIterator = this.g.getPotentialPredecessorOf(i).iterator();
            while (iSetIterator.hasNext()) {
                int y = (Integer)iSetIterator.next();
                this.connectedGraph.addEdge(y, i);
            }
            if (this.g.getPotentialNodes().contains(i)) continue;
            this.connectedGraph.addEdge(this.n, i);
        }
        this.connectedGraph.addEdge(this.n, this.root);
    }

    protected void explore() {
        this.visited.clear();
        int first = 0;
        int last = 0;
        int i = this.root;
        this.fifo[last++] = i;
        this.visited.set(i);
        while (first < last) {
            i = this.fifo[first++];
            ISetIterator iSetIterator = this.g.getPotentialSuccessorsOf(i).iterator();
            while (iSetIterator.hasNext()) {
                int j = (Integer)iSetIterator.next();
                if (this.visited.get(j)) continue;
                this.visited.set(j);
                this.fifo[last++] = j;
            }
        }
    }

    @Override
    public ESat isEntailed() {
        if (!this.g.getPotentialNodes().contains(this.root)) {
            return ESat.FALSE;
        }
        StrongConnectivityFinder scfinder = new StrongConnectivityFinder((DirectedGraph)this.g.getLB());
        scfinder.findAllSCC();
        if (this.g.getMandatoryNodes().size() - scfinder.getNbSCC() > 0) {
            return ESat.FALSE;
        }
        if (this.g.getMandatoryPredecessorsOf(this.root).size() > 0) {
            return ESat.FALSE;
        }
        ISetIterator iSetIterator = this.g.getMandatoryNodes().iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            if (i == this.root || this.g.getMandatoryPredecessorsOf(i).size() <= 1 || this.g.getPotentialPredecessorOf(i).size() != 0) continue;
            return ESat.FALSE;
        }
        if (this.g.isInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

