/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.set;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.ISetDeltaMonitor;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.procedure.IntProcedure;

public class PropNotMemberSetInt
extends Propagator<SetVar> {
    private final IntVar iv;
    private final SetVar sv;
    private final ISetDeltaMonitor sdm;
    private final IntProcedure elemRem;

    public PropNotMemberSetInt(IntVar intVar, SetVar setVar) {
        super((Variable[])new SetVar[]{setVar}, (Priority)PropagatorPriority.UNARY, true);
        this.iv = intVar;
        this.sv = setVar;
        this.sdm = this.sv.monitorDelta(this);
        this.elemRem = i -> this.iv.removeValue(i, (ICause)this);
    }

    @Override
    public int getPropagationConditions(int vidx) {
        return SetEventType.ADD_TO_KER.getMask();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        ISetIterator iter = this.sv.getLB().iterator();
        while (iter.hasNext()) {
            this.iv.removeValue(iter.nextInt(), (ICause)this);
        }
        if (this.sv.isInstantiated()) {
            this.setPassive();
        }
        this.sdm.startMonitoring();
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.sdm.forEach(this.elemRem, SetEventType.ADD_TO_KER);
        if (this.sv.isInstantiated()) {
            this.setPassive();
        }
    }

    @Override
    public ESat isEntailed() {
        if (this.iv.isInstantiated()) {
            int v = this.iv.getValue();
            if (this.sv.getUB().contains(v)) {
                if (this.sv.getLB().contains(v)) {
                    return ESat.FALSE;
                }
                return ESat.UNDEFINED;
            }
            return ESat.TRUE;
        }
        int v = this.iv.getLB();
        while (v <= this.iv.getUB()) {
            if (!this.sv.getLB().contains(v)) {
                return ESat.UNDEFINED;
            }
            v = this.iv.nextValue(v);
        }
        return ESat.FALSE;
    }
}

