% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fs_upload.R
\name{fs_upload}
\alias{fs_upload}
\title{Upload file to an article}
\usage{
fs_upload(article_id, file, session = fs_get_auth())
}
\arguments{
\item{article_id}{an article id number or a character string (or list) of numbers}

\item{file}{path to file to upload, or character string (or list) of files (paths)}

\item{session}{the authentication credentials from \code{\link{fs_auth}} (optional)}
}
\description{
Upload file to an article
}
\details{
Articles may be draft, private or public but all uploads are saved as draft changes - the canonical public version of the deposit is not updated. To update the public version of the repository, use \code{\link{fs_make_public}}. Only articles of type "fileset" can have multiple files uploaded.

If only a single id number is given but a character string of files is given,
then be sure that the id corresponds to an object of type "fileset".  If article_id list
has more than one id, then there must be a corresponding file path for each id.
}
\examples{
\dontrun{
id <- fs_create("Title", "description", "figure")
fs_upload(id, "file.png")
} 
}
\references{
\url{https://docs.figshare.com}
}
\seealso{
\code{\link{fs_auth}}
}
\author{
Carl Boettiger \email{cboettig@gmail.com}
}
