% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/species.R
\name{species}
\alias{species}
\title{species}
\usage{
species(
  species_list = NULL,
  fields = NULL,
  server = c("fishbase", "sealifebase"),
  version = "latest",
  db = NULL,
  ...
)
}
\arguments{
\item{species_list}{A vector of scientific names (each element as "genus species"). If empty, a table for all fish will be returned.}

\item{fields}{subset to these columns.  (recommend to omit this and handle manually)}

\item{server}{Either "fishbase" or "sealifebase".}

\item{version}{a version string for the database. See \code{\link[=available_releases]{available_releases()}} for details.}

\item{db}{database connection, now deprecated.}

\item{...}{additional arguments, currently ignored}
}
\value{
a data.frame with rows for species and columns for the fields returned by the query (FishBase 'species' table)
}
\description{
Provide wrapper to work with species lists.
}
\details{
The Species table is the heart of FishBase. This function provides a convenient way to
query, tidy, and assemble data from that table given an entire list of species.
For details, see: http://www.fishbase.org/manual/english/fishbasethe_species_table.htm

Species scientific names are defined according to fishbase taxonomy and nomenclature.
}
\examples{
\dontrun{

species(c("Labroides bicolor", "Bolbometopon muricatum")) 

}
}
