% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fhist.R
\name{f_hist}
\alias{f_hist}
\title{Plot a Histogram with an Overlaid Normal Curve}
\usage{
f_hist(
  data,
  main = NULL,
  xlab = NULL,
  probability = TRUE,
  col = "white",
  border = "black",
  line_col = "red",
  save_png = FALSE,
  open_png = TRUE,
  output_file = NULL,
  output_dir = NULL,
  save_in_wdir = FALSE,
  width = 8,
  height = 7,
  units = "in",
  res = 300,
  ...
)
}
\arguments{
\item{data}{A numeric vector of data values to be plotted.}

\item{main}{A character string specifying the title of the histogram. Default is \code{"Histogram with Normal Curve"}.}

\item{xlab}{A character string specifying the label for the x-axis. Default is the name of the data variable.}

\item{probability}{A logical value indicating whether to plot a probability or frequency histogram. Default is \code{TRUE}.}

\item{col}{A character string specifying the fill color of the histogram bars. Default is \code{"white"}.}

\item{border}{A character string specifying the color of the histogram bar borders. Default is \code{"black"}.}

\item{line_col}{A character string specifying the color of the normal curve line. Default is \code{"red"}.}

\item{save_png}{A logical value default \code{FALSE}, if \code{TRUE} a png file is saved under the name of the data of under the specified file name.}

\item{open_png}{Logical. If \code{TRUE}, opens generated png files.}

\item{output_file}{Character string specifying the name of the output file (without extension). Default is the name of the vector or dataframe followed by "_histogram.png".}

\item{output_dir}{Character string specifying the name of the directory of the output file. Default is  \code{tempdir()}. If the \code{output_file} already contains a directory name \code{output_dir} can be omitted, if used it overwrites the dir specified in \code{output_file}.}

\item{save_in_wdir}{Logical. If \code{TRUE}, saves the file in the working directory Default is \code{FALSE}, to avoid unintended changes to the global environment. If the \code{output_dir} is specified \code{save_in_wdir} is overwritten with \code{output_dir}.}

\item{width}{Numeric, png figure width default \code{8} inch.}

\item{height}{Numeric, png figure height default \code{7} inch.}

\item{units}{Character string, png figure units default \code{"in"} = inch, other options are: \code{"px"} = Pixels, \code{"cm"} centimeters, \code{"mm"} millimeters.}

\item{res}{Numeric, png figure resolution default \code{300} dpi.}

\item{...}{Additional arguments to be passed to the \code{hist} function.}
}
\value{
A histogram plot is created and the function returns this as a \code{recordedplot}.
}
\description{
This function creates a histogram of the provided data and overlays it with a normal distribution curve.
}
\details{
The function first captures the name of the input variable for labeling purposes. It then calculates a sequence of x-values and corresponding y-values for a normal distribution based on the mean and standard deviation of the data. The histogram is plotted with specified aesthetics, and a normal curve is overlaid. To increase resolution you can use \code{png(...,res = 600)} or the 'RStudio' chunk setting, e.g. \code{dpi=600}.
}
\examples{
# Example usage:
set.seed(123)
sample_data <- rnorm(100)
f_hist(sample_data)


}
\seealso{
\href{https://stat.ethz.ch/R-manual/R-devel/library/graphics/html/hist.html}{\code{hist}}, \href{https://stat.ethz.ch/R-manual/R-devel/library/stats/html/Normal.html}{\code{dnorm}},  \href{https://stat.ethz.ch/R-manual/R-devel/library/graphics/html/lines.html}{\code{lines}}
}
\author{
Sander H. van Delden  \email{plantmind@proton.me} \cr
}
