% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_fetch.R
\name{map_fetch}
\alias{map_fetch}
\title{Fetch maps of GBIF occurrences}
\usage{
map_fetch(
  source = "density",
  x = 0:1,
  y = 0,
  z = 0,
  format = "@1x.png",
  srs = "EPSG:4326",
  bin = NULL,
  hexPerTile = NULL,
  squareSize = NULL,
  style = NULL,
  taxonKey = NULL,
  datasetKey = NULL,
  country = NULL,
  publishingOrg = NULL,
  publishingCountry = NULL,
  year = NULL,
  basisOfRecord = NULL,
  return = "png",
  base_style = NULL,
  plot_terra = TRUE,
  curlopts = list(http_version = 2),
  ...
)
}
\arguments{
\item{source}{(character) Either \code{density} for fast, precalculated tiles,
or \code{adhoc} for any search. Default: \code{density}}

\item{x}{(integer sequence) the column. Default: 0:1}

\item{y}{(integer sequence) the row. Default: 0}

\item{z}{(integer) the zoom. Default: 0}

\item{format}{(character) The data format, one of:
\itemize{
\item \verb{@Hx.png} for a 256px raster tile
\item \verb{@1x.png} for a 512px raster tile (the default)
\item \verb{@2x.png} for a 1024px raster tile
\item \verb{@3x.png} for a 2048px raster tile
\item \verb{@4x.png} for a 4096px raster tile
}}

\item{srs}{(character) Spatial reference system. One of:
\itemize{
\item \code{EPSG:3857} (Web Mercator)
\item \code{EPSG:4326} (WGS84 plate care?)
\item \code{EPSG:3575} (Arctic LAEA on 10 degrees E)
\item \code{EPSG:3031} (Antarctic stereographic)
}}

\item{bin}{(character) \code{square} or \code{hex} to aggregate occurrence counts into
squares or hexagons. Points by default.}

\item{hexPerTile}{(integer) sets the size of the hexagons
(the number horizontally across a tile).}

\item{squareSize}{(integer) sets the size of the squares. Choose a factor
of 4096 so they tessalate correctly: probably from 8, 16, 32, 64, 128,
256, 512.}

\item{style}{(character) for raster tiles, choose from the available styles.
Defaults to classic.point for source="density" and "scaled.circle" for source="adhoc".}

\item{taxonKey}{(integer/numeric/character) search by taxon key, can only
supply 1.}

\item{datasetKey}{(character) search by taxon key, can only supply 1.}

\item{country}{(character) search by taxon key, can only supply 1.}

\item{publishingOrg}{(character) search by taxon key, can only supply 1.}

\item{publishingCountry}{(character) search by taxon key, can only
supply 1.}

\item{year}{(integer) integer that limits the search to a certain year or,
if passing a vector of integers, multiple years, for example
\code{1984} or \code{c(2016, 2017, 2018)} or \code{2010:2015} (years 2010 to 2015). optional}

\item{basisOfRecord}{(character) one or more basis of record states to
include records with that basis of record. The full list is: \code{c("OBSERVATION", "HUMAN_OBSERVATION", "MACHINE_OBSERVATION", "MATERIAL_SAMPLE", "PRESERVED_SPECIMEN", "FOSSIL_SPECIMEN", "LIVING_SPECIMEN", "LITERATURE", "UNKNOWN")}.}

\item{return}{(character) Either "png" or "terra".}

\item{base_style}{(character)  The style of the base map.}

\item{plot_terra}{(logical) Set whether the terra map be default plotted.}

\item{curlopts}{options passed on to \link[crul:HttpClient]{crul::HttpClient}}

\item{...}{additional arguments passed to the adhoc interface.}
}
\value{
a \code{magick-image} or \code{terra::SpatRaster } object.
}
\description{
This function is a wrapper for the GBIF mapping api version 2.0.
The mapping API is a web map tile service making it straightforward to
visualize GBIF content on interactive maps, and overlay content from other
sources. It returns tile maps with number of
GBIF records per area unit that can be used in a variety of ways, for example
in interactive leaflet web maps. Map details are specified by a number of
query parameters, some of them optional. Full documentation of the GBIF
mapping api can be found at https://www.gbif.org/developer/maps
}
\details{
The default settings, \code{return='png'}, will return a \code{magick-image}
png. This image will be a composite image of the the occurrence tiles fetched
and a base map. This map is primarily useful as a high quality image of
occurrence records.

The args \code{x} and \code{y} can both be integer sequences. For example, \code{x=0:3} or
\code{y=0:1}. Note that the tile index starts at 0. Higher values of \code{z}, will
will produce more tiles that can be fetched and stitched together. Selecting
a too high value for \code{x} or \code{y} will produce a blank image.

Setting \code{return='terra'} will return a \code{terra::SpatRaster } object. This
is primarily useful if you were interested in the underlying aggregated
occurrence density data.

See the article
}
\examples{
\dontrun{

# all occurrences
map_fetch()
# get artic map
map_fetch(srs='EPSG:3031') 
# only preserved specimens
map_fetch(basisOfRecord="PRESERVED_SPECIMEN")

# Map of occ in Great Britain
map_fetch(z=3,y=1,x=7:8,country="GB")
# Peguins with artic projection
map_fetch(srs='EPSG:3031',taxonKey=2481660,style='glacier.point', 
base_style="gbif-dark")

# occ from a long time ago
map_fetch(year=1600) 
# polygon style 
map_fetch(style="iNaturalist.poly",bin="hex")
# iNaturalist dataset plotted 
map_fetch(datasetKey="50c9509d-22c7-4a22-a47d-8c48425ef4a7",
  style="iNaturalist.poly")
 
# use source="adhoc" for more filters
map_fetch(z=1,
  source="adhoc",
  iucn_red_list_category="CR",
  style="scaled.circles",
  base_style='gbif-light')

# cropped map of Hawaii
map_fetch(z=5,x=3:4,y=12,source="adhoc",gadmGid="USA.12_1")


}
}
\references{
https://www.gbif.org/developer/maps

https://api.gbif.org/v2/map/demo.html

https://api.gbif.org/v2/map/demo13.html
}
\seealso{
\code{\link[=mvt_fetch]{mvt_fetch()}}
}
\author{
John Waller and Laurens Geffert \email{laurensgeffert@gmail.com}
}
