% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/special-orthogonal.R
\name{SpecialOrthogonal3Vectors}
\alias{SpecialOrthogonal3Vectors}
\title{Abstract Class for the 3D Special Orthogonal Group in Vector Representation}
\description{
Class for the special orthogonal group \eqn{\mathrm{SO}(3)} in
vector form, i.e. the Lie group of 3D rotations. This class is specific to
the vector representation of rotations. For the matrix representation, use
the \code{\link{SpecialOrthogonal}} class and set \code{n = 3}.
}
\examples{

## ------------------------------------------------
## Method `SpecialOrthogonal3Vectors$rotation_vector_from_matrix`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$rotation_vector_from_matrix(diag(1, 3))
}

## ------------------------------------------------
## Method `SpecialOrthogonal3Vectors$matrix_from_rotation_vector`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$matrix_from_rotation_vector(rep(0, 3))
}

## ------------------------------------------------
## Method `SpecialOrthogonal3Vectors$quaternion_from_matrix`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$quaternion_from_matrix(diag(1, 3))
}

## ------------------------------------------------
## Method `SpecialOrthogonal3Vectors$quaternion_from_rotation_vector`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$quaternion_from_rotation_vector(rep(0, 3))
}

## ------------------------------------------------
## Method `SpecialOrthogonal3Vectors$rotation_vector_from_quaternion`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$rotation_vector_from_quaternion(array(c(1, rep(0, 3))))
}

## ------------------------------------------------
## Method `SpecialOrthogonal3Vectors$matrix_from_quaternion`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$matrix_from_quaternion(c(1, rep(0, 3)))
}

## ------------------------------------------------
## Method `SpecialOrthogonal3Vectors$matrix_from_tait_bryan_angles`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$matrix_from_tait_bryan_angles(rep(0, 3))
}

## ------------------------------------------------
## Method `SpecialOrthogonal3Vectors$tait_bryan_angles_from_matrix`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$tait_bryan_angles_from_matrix(diag(1, 3))
}

## ------------------------------------------------
## Method `SpecialOrthogonal3Vectors$quaternion_from_tait_bryan_angles`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$quaternion_from_tait_bryan_angles(rep(0, 3))
}

## ------------------------------------------------
## Method `SpecialOrthogonal3Vectors$rotation_vector_from_tait_bryan_angles`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$rotation_vector_from_tait_bryan_angles(rep(0, 3))
}

## ------------------------------------------------
## Method `SpecialOrthogonal3Vectors$tait_bryan_angles_from_quaternion`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$tait_bryan_angles_from_quaternion(c(1, rep(0, 3)))
}

## ------------------------------------------------
## Method `SpecialOrthogonal3Vectors$tait_bryan_angles_from_rotation_vector`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$tait_bryan_angles_from_rotation_vector(rep(0, 3))
}

## ------------------------------------------------
## Method `SpecialOrthogonal3Vectors$random_uniform`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$random_uniform()
}
}
\seealso{
Other special orthogonal classes: 
\code{\link{SpecialOrthogonal2Vectors}},
\code{\link{SpecialOrthogonalMatrices}},
\code{\link{SpecialOrthogonal}()}
}
\author{
Nicolas Guigui and Nina Miolane
}
\concept{special orthogonal classes}
\keyword{internal}
\section{Super classes}{
\code{rgeomstats::PythonClass} -> \code{\link[rgeomstats:Manifold]{rgeomstats::Manifold}} -> \code{\link[rgeomstats:LieGroup]{rgeomstats::LieGroup}} -> \code{\link[rgeomstats:SpecialOrthogonalVectors]{rgeomstats::SpecialOrthogonalVectors}} -> \code{SpecialOrthogonal3Vectors}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{bi_invariant_metric}}{An object of class \code{BiInvariantMetric}
specifying the metric to equip the manifold with.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SpecialOrthogonal3Vectors-new}{\code{SpecialOrthogonal3Vectors$new()}}
\item \href{#method-SpecialOrthogonal3Vectors-rotation_vector_from_matrix}{\code{SpecialOrthogonal3Vectors$rotation_vector_from_matrix()}}
\item \href{#method-SpecialOrthogonal3Vectors-matrix_from_rotation_vector}{\code{SpecialOrthogonal3Vectors$matrix_from_rotation_vector()}}
\item \href{#method-SpecialOrthogonal3Vectors-quaternion_from_matrix}{\code{SpecialOrthogonal3Vectors$quaternion_from_matrix()}}
\item \href{#method-SpecialOrthogonal3Vectors-quaternion_from_rotation_vector}{\code{SpecialOrthogonal3Vectors$quaternion_from_rotation_vector()}}
\item \href{#method-SpecialOrthogonal3Vectors-rotation_vector_from_quaternion}{\code{SpecialOrthogonal3Vectors$rotation_vector_from_quaternion()}}
\item \href{#method-SpecialOrthogonal3Vectors-matrix_from_quaternion}{\code{SpecialOrthogonal3Vectors$matrix_from_quaternion()}}
\item \href{#method-SpecialOrthogonal3Vectors-matrix_from_tait_bryan_angles}{\code{SpecialOrthogonal3Vectors$matrix_from_tait_bryan_angles()}}
\item \href{#method-SpecialOrthogonal3Vectors-tait_bryan_angles_from_matrix}{\code{SpecialOrthogonal3Vectors$tait_bryan_angles_from_matrix()}}
\item \href{#method-SpecialOrthogonal3Vectors-quaternion_from_tait_bryan_angles}{\code{SpecialOrthogonal3Vectors$quaternion_from_tait_bryan_angles()}}
\item \href{#method-SpecialOrthogonal3Vectors-rotation_vector_from_tait_bryan_angles}{\code{SpecialOrthogonal3Vectors$rotation_vector_from_tait_bryan_angles()}}
\item \href{#method-SpecialOrthogonal3Vectors-tait_bryan_angles_from_quaternion}{\code{SpecialOrthogonal3Vectors$tait_bryan_angles_from_quaternion()}}
\item \href{#method-SpecialOrthogonal3Vectors-tait_bryan_angles_from_rotation_vector}{\code{SpecialOrthogonal3Vectors$tait_bryan_angles_from_rotation_vector()}}
\item \href{#method-SpecialOrthogonal3Vectors-random_uniform}{\code{SpecialOrthogonal3Vectors$random_uniform()}}
\item \href{#method-SpecialOrthogonal3Vectors-clone}{\code{SpecialOrthogonal3Vectors$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgeomstats/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgeomstats::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgeomstats/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgeomstats::PythonClass$set_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="belongs"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-belongs'><code>rgeomstats::Manifold$belongs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="is_tangent"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-is_tangent'><code>rgeomstats::Manifold$is_tangent()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="random_point"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-random_point'><code>rgeomstats::Manifold$random_point()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="random_tangent_vec"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-random_tangent_vec'><code>rgeomstats::Manifold$random_tangent_vec()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="regularize"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-regularize'><code>rgeomstats::Manifold$regularize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="set_metric"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-set_metric'><code>rgeomstats::Manifold$set_metric()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="to_tangent"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-to_tangent'><code>rgeomstats::Manifold$to_tangent()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="LieGroup" data-id="add_metric"><a href='../../rgeomstats/html/LieGroup.html#method-LieGroup-add_metric'><code>rgeomstats::LieGroup$add_metric()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="LieGroup" data-id="compose"><a href='../../rgeomstats/html/LieGroup.html#method-LieGroup-compose'><code>rgeomstats::LieGroup$compose()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="LieGroup" data-id="exp"><a href='../../rgeomstats/html/LieGroup.html#method-LieGroup-exp'><code>rgeomstats::LieGroup$exp()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="LieGroup" data-id="exp_from_identity"><a href='../../rgeomstats/html/LieGroup.html#method-LieGroup-exp_from_identity'><code>rgeomstats::LieGroup$exp_from_identity()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="LieGroup" data-id="exp_not_from_identity"><a href='../../rgeomstats/html/LieGroup.html#method-LieGroup-exp_not_from_identity'><code>rgeomstats::LieGroup$exp_not_from_identity()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="LieGroup" data-id="get_identity"><a href='../../rgeomstats/html/LieGroup.html#method-LieGroup-get_identity'><code>rgeomstats::LieGroup$get_identity()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="LieGroup" data-id="inverse"><a href='../../rgeomstats/html/LieGroup.html#method-LieGroup-inverse'><code>rgeomstats::LieGroup$inverse()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="LieGroup" data-id="jacobian_translation"><a href='../../rgeomstats/html/LieGroup.html#method-LieGroup-jacobian_translation'><code>rgeomstats::LieGroup$jacobian_translation()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="LieGroup" data-id="lie_bracket"><a href='../../rgeomstats/html/LieGroup.html#method-LieGroup-lie_bracket'><code>rgeomstats::LieGroup$lie_bracket()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="LieGroup" data-id="log"><a href='../../rgeomstats/html/LieGroup.html#method-LieGroup-log'><code>rgeomstats::LieGroup$log()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="LieGroup" data-id="log_from_identity"><a href='../../rgeomstats/html/LieGroup.html#method-LieGroup-log_from_identity'><code>rgeomstats::LieGroup$log_from_identity()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="LieGroup" data-id="log_not_from_identity"><a href='../../rgeomstats/html/LieGroup.html#method-LieGroup-log_not_from_identity'><code>rgeomstats::LieGroup$log_not_from_identity()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="LieGroup" data-id="tangent_translation_map"><a href='../../rgeomstats/html/LieGroup.html#method-LieGroup-tangent_translation_map'><code>rgeomstats::LieGroup$tangent_translation_map()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="SpecialOrthogonalVectors" data-id="projection"><a href='../../rgeomstats/html/SpecialOrthogonalVectors.html#method-SpecialOrthogonalVectors-projection'><code>rgeomstats::SpecialOrthogonalVectors$projection()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="SpecialOrthogonalVectors" data-id="regularize_tangent_vec"><a href='../../rgeomstats/html/SpecialOrthogonalVectors.html#method-SpecialOrthogonalVectors-regularize_tangent_vec'><code>rgeomstats::SpecialOrthogonalVectors$regularize_tangent_vec()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="SpecialOrthogonalVectors" data-id="regularize_tangent_vec_at_identity"><a href='../../rgeomstats/html/SpecialOrthogonalVectors.html#method-SpecialOrthogonalVectors-regularize_tangent_vec_at_identity'><code>rgeomstats::SpecialOrthogonalVectors$regularize_tangent_vec_at_identity()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="SpecialOrthogonalVectors" data-id="skew_matrix_from_vector"><a href='../../rgeomstats/html/SpecialOrthogonalVectors.html#method-SpecialOrthogonalVectors-skew_matrix_from_vector'><code>rgeomstats::SpecialOrthogonalVectors$skew_matrix_from_vector()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="SpecialOrthogonalVectors" data-id="vector_from_skew_matrix"><a href='../../rgeomstats/html/SpecialOrthogonalVectors.html#method-SpecialOrthogonalVectors-vector_from_skew_matrix'><code>rgeomstats::SpecialOrthogonalVectors$vector_from_skew_matrix()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpecialOrthogonal3Vectors-new"></a>}}
\if{latex}{\out{\hypertarget{method-SpecialOrthogonal3Vectors-new}{}}}
\subsection{Method \code{new()}}{
The \code{\link{SpecialOrthogonal3Vectors}} class constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpecialOrthogonal3Vectors$new(epsilon = 0, py_cls = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{epsilon}}{A numeric value specifying the precision to use for
calculations involving potential division by 0 in rotations. Defaults to
\code{0}.}

\item{\code{py_cls}}{A Python object of class \code{SpecialOrthogonal3Vectors}.
Defaults to \code{NULL} in which case it is instantiated on the fly using
the other input arguments.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \code{\link{SpecialOrthogonal3Vectors}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpecialOrthogonal3Vectors-rotation_vector_from_matrix"></a>}}
\if{latex}{\out{\hypertarget{method-SpecialOrthogonal3Vectors-rotation_vector_from_matrix}{}}}
\subsection{Method \code{rotation_vector_from_matrix()}}{
Converts a 3D rotation from matrix to axis-angle
representation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpecialOrthogonal3Vectors$rotation_vector_from_matrix(rot_mat)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rot_mat}}{A numeric array of shape \eqn{[\dots \times 3 \times 3]}
specifying one or more 3D rotation matrices.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Gets the angle \eqn{\theta} through the trace of the rotation
matrix. The eigenvalues are: \deqn{\{ 1, \cos \theta + i \sin \theta,
  \cos \theta - i \sin \theta \}} so that \deqn{\mathrm{trace} = 1 + 2
  \cos \theta, \{ -1 \leq \mathrm{trace} \leq 3 \}.}

The rotation vector is the vector associated to the skew-symmetric matrix
\deqn{S_r = \frac{\theta}{(2 \sin \theta) (R - R^T)}.}

For the edge case where the angle is close to \eqn{\pi}, the rotation
vector (up to sign) is derived by using the following equality (see the
axis-angle representation on Wikipedia): \deqn{\mathrm{outer}(r, r) =
\frac{1}{2} (R + I_3).}

In nD, the rotation vector stores the \eqn{n(n-1)/2} values of the
skew-symmetric matrix representing the rotation.
}

\subsection{Returns}{
A numeric array of shape \eqn{[\dots \times 3]} storing the
corresponding axis-angle representations.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$rotation_vector_from_matrix(diag(1, 3))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpecialOrthogonal3Vectors-matrix_from_rotation_vector"></a>}}
\if{latex}{\out{\hypertarget{method-SpecialOrthogonal3Vectors-matrix_from_rotation_vector}{}}}
\subsection{Method \code{matrix_from_rotation_vector()}}{
Converts a 3D rotation from axis-angle to matrix
representation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpecialOrthogonal3Vectors$matrix_from_rotation_vector(rot_vec)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rot_vec}}{A numeric array of shape \eqn{[\dots \times 3]} specifying
one or more 3D rotations in axis-angle representation.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of shape \eqn{[\dots \times 3 \times 3]} storing
the corresponding matrix representations.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$matrix_from_rotation_vector(rep(0, 3))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpecialOrthogonal3Vectors-quaternion_from_matrix"></a>}}
\if{latex}{\out{\hypertarget{method-SpecialOrthogonal3Vectors-quaternion_from_matrix}{}}}
\subsection{Method \code{quaternion_from_matrix()}}{
Converts a 3D rotation from matrix to unit quaternion
representation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpecialOrthogonal3Vectors$quaternion_from_matrix(rot_mat)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rot_mat}}{A numeric array of shape \eqn{[\dots \times 3 \times 3]}
specifying one or more 3D rotations in matrix representation.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of shape \eqn{[\dots \times 4]} storing the
corresponding unit quaternion representations.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$quaternion_from_matrix(diag(1, 3))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpecialOrthogonal3Vectors-quaternion_from_rotation_vector"></a>}}
\if{latex}{\out{\hypertarget{method-SpecialOrthogonal3Vectors-quaternion_from_rotation_vector}{}}}
\subsection{Method \code{quaternion_from_rotation_vector()}}{
Converts a 3D rotation from axis-angle to unit quaternion
representation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpecialOrthogonal3Vectors$quaternion_from_rotation_vector(rot_vec)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rot_vec}}{A numeric array of shape \eqn{[\dots \times 3]} specifying
one or more 3D rotations in axis-angle representation.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of shape \eqn{[\dots \times 4]} storing the
corresponding unit quaternion representations.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$quaternion_from_rotation_vector(rep(0, 3))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpecialOrthogonal3Vectors-rotation_vector_from_quaternion"></a>}}
\if{latex}{\out{\hypertarget{method-SpecialOrthogonal3Vectors-rotation_vector_from_quaternion}{}}}
\subsection{Method \code{rotation_vector_from_quaternion()}}{
Converts a 3D rotation from unit quaternion to axis-angle
representation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpecialOrthogonal3Vectors$rotation_vector_from_quaternion(quaternion)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{quaternion}}{A numeric array of shape \eqn{[\dots \times 4]}
specifying one or more 3D rotations in unit quaternion representation.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of shape \eqn{[\dots \times 3]} storing the
corresponding axis-angle representations.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$rotation_vector_from_quaternion(array(c(1, rep(0, 3))))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpecialOrthogonal3Vectors-matrix_from_quaternion"></a>}}
\if{latex}{\out{\hypertarget{method-SpecialOrthogonal3Vectors-matrix_from_quaternion}{}}}
\subsection{Method \code{matrix_from_quaternion()}}{
Converts a 3D rotation from unit quaternion to matrix
representation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpecialOrthogonal3Vectors$matrix_from_quaternion(quaternion)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{quaternion}}{A numeric array of shape \eqn{[\dots \times 4]}
specifying one or more 3D rotations in unit quaternion representation.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of shape \eqn{[\dots \times 3 \times 3]} storing
the corresponding matrix representations.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$matrix_from_quaternion(c(1, rep(0, 3)))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpecialOrthogonal3Vectors-matrix_from_tait_bryan_angles"></a>}}
\if{latex}{\out{\hypertarget{method-SpecialOrthogonal3Vectors-matrix_from_tait_bryan_angles}{}}}
\subsection{Method \code{matrix_from_tait_bryan_angles()}}{
Converts a 3D rotation from Tait-Bryan angle to matrix
representation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpecialOrthogonal3Vectors$matrix_from_tait_bryan_angles(
  tait_bryan_angles,
  extrinsic_or_intrinsic = "extrinsic",
  order = "zyx"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tait_bryan_angles}}{A numeric array of shape \eqn{[\dots \times 3]}
specifying one or more 3D rotations in Tait-Bryan angle representation.}

\item{\code{extrinsic_or_intrinsic}}{A character string specifying the
coordinate frame in which the Tait-Bryan angles are expressed. Choices
are either \code{"extrinsic"} (fixed frame) or \code{"intrinsic"} (moving frame).
Defaults to \code{"extrinsic"}.}

\item{\code{order}}{A character string specifying the order of the rotation
composition around the three axes of the chosen coordinate frame.
Choices are either \code{"xyz"} or \code{"zyx"}. Defaults to \code{"zyx"}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Converts a rotation given in terms of the Tait-Bryan angles
\verb{[angle_1, angle_2, angle_3]} in extrinsic (fixed) or intrinsic
(moving) coordinate frame in the corresponding matrix representation.
If the order is \code{zyx}, into the rotation matrix \verb{rot_mat = X(angle_1) Y(angle_2) Z(angle_3)} where:
\itemize{
\item \code{X(angle_1)} is a rotation of angle \code{angle_1} around axis \code{x};
\item \code{Y(angle_2)} is a rotation of angle \code{angle_2} around axis \code{y};
\item \code{Z(angle_3)} is a rotation of angle \code{angle_3} around axis \code{z}.
}

Exchanging \code{'extrinsic'} and \code{'intrinsic'} amounts to exchanging the
order.
}

\subsection{Returns}{
A numeric array of shape \eqn{[\dots \times 3 \times 3]} storing
the corresponding matrix representations.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$matrix_from_tait_bryan_angles(rep(0, 3))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpecialOrthogonal3Vectors-tait_bryan_angles_from_matrix"></a>}}
\if{latex}{\out{\hypertarget{method-SpecialOrthogonal3Vectors-tait_bryan_angles_from_matrix}{}}}
\subsection{Method \code{tait_bryan_angles_from_matrix()}}{
Converts a 3D rotation from matrix to Tait-Bryan angle
representation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpecialOrthogonal3Vectors$tait_bryan_angles_from_matrix(
  rot_mat,
  extrinsic_or_intrinsic = "extrinsic",
  order = "zyx"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rot_mat}}{A numeric array of shape \eqn{[\dots \times 3 \times 3]}
specifying one or more 3D rotations in matrix representation.}

\item{\code{extrinsic_or_intrinsic}}{A character string specifying the
coordinate frame in which the Tait-Bryan angles are expressed. Choices
are either \code{"extrinsic"} (fixed frame) or \code{"intrinsic"} (moving frame).
Defaults to \code{"extrinsic"}.}

\item{\code{order}}{A character string specifying the order of the rotation
composition around the three axes of the chosen coordinate frame.
Choices are either \code{"xyz"} or \code{"zyx"}. Defaults to \code{"zyx"}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Converts a rotation given in matrix representation into its
Tait-Bryan angle representation \verb{[angle_1, angle_2, angle_3]} in
extrinsic (fixed) or intrinsic (moving) coordinate frame in the
corresponding matrix representation. If the order is \code{zyx}, into the
rotation matrix \verb{rot_mat = X(angle_1) Y(angle_2) Z(angle_3)} where:
\itemize{
\item \code{X(angle_1)} is a rotation of angle \code{angle_1} around axis \code{x};
\item \code{Y(angle_2)} is a rotation of angle \code{angle_2} around axis \code{y};
\item \code{Z(angle_3)} is a rotation of angle \code{angle_3} around axis \code{z}.
}

Exchanging \code{'extrinsic'} and \code{'intrinsic'} amounts to exchanging the
order.
}

\subsection{Returns}{
A numeric array of shape \eqn{[\dots \times 3]} storing the
corresponding Tait-Bryan angle representations.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$tait_bryan_angles_from_matrix(diag(1, 3))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpecialOrthogonal3Vectors-quaternion_from_tait_bryan_angles"></a>}}
\if{latex}{\out{\hypertarget{method-SpecialOrthogonal3Vectors-quaternion_from_tait_bryan_angles}{}}}
\subsection{Method \code{quaternion_from_tait_bryan_angles()}}{
Converts a 3D rotation from Tait-Bryan angle to unit
quaternion representation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpecialOrthogonal3Vectors$quaternion_from_tait_bryan_angles(
  tait_bryan_angles,
  extrinsic_or_intrinsic = "extrinsic",
  order = "zyx"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tait_bryan_angles}}{A numeric array of shape \eqn{[\dots \times 3]}
specifying one or more 3D rotations in Tait-Bryan angle representation.}

\item{\code{extrinsic_or_intrinsic}}{A character string specifying the
coordinate frame in which the Tait-Bryan angles are expressed. Choices
are either \code{"extrinsic"} (fixed frame) or \code{"intrinsic"} (moving frame).
Defaults to \code{"extrinsic"}.}

\item{\code{order}}{A character string specifying the order of the rotation
composition around the three axes of the chosen coordinate frame.
Choices are either \code{"xyz"} or \code{"zyx"}. Defaults to \code{"zyx"}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of shape \eqn{[\dots \times 4]} storing the
corresponding unit quaternion representations.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$quaternion_from_tait_bryan_angles(rep(0, 3))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpecialOrthogonal3Vectors-rotation_vector_from_tait_bryan_angles"></a>}}
\if{latex}{\out{\hypertarget{method-SpecialOrthogonal3Vectors-rotation_vector_from_tait_bryan_angles}{}}}
\subsection{Method \code{rotation_vector_from_tait_bryan_angles()}}{
Converts a 3D rotation from Tait-Bryan angle to axis-angle
representation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpecialOrthogonal3Vectors$rotation_vector_from_tait_bryan_angles(
  tait_bryan_angles,
  extrinsic_or_intrinsic = "extrinsic",
  order = "zyx"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tait_bryan_angles}}{A numeric array of shape \eqn{[\dots \times 3]}
specifying one or more 3D rotations in Tait-Bryan angle representation.}

\item{\code{extrinsic_or_intrinsic}}{A character string specifying the
coordinate frame in which the Tait-Bryan angles are expressed. Choices
are either \code{"extrinsic"} (fixed frame) or \code{"intrinsic"} (moving frame).
Defaults to \code{"extrinsic"}.}

\item{\code{order}}{A character string specifying the order of the rotation
composition around the three axes of the chosen coordinate frame.
Choices are either \code{"xyz"} or \code{"zyx"}. Defaults to \code{"zyx"}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of shape \eqn{[\dots \times 3]} storing the
corresponding axis-angle representations.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$rotation_vector_from_tait_bryan_angles(rep(0, 3))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpecialOrthogonal3Vectors-tait_bryan_angles_from_quaternion"></a>}}
\if{latex}{\out{\hypertarget{method-SpecialOrthogonal3Vectors-tait_bryan_angles_from_quaternion}{}}}
\subsection{Method \code{tait_bryan_angles_from_quaternion()}}{
Converts a 3D rotation from matrix to Tait-Bryan angle
representation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpecialOrthogonal3Vectors$tait_bryan_angles_from_quaternion(
  quaternion,
  extrinsic_or_intrinsic = "extrinsic",
  order = "zyx"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{quaternion}}{A numeric array of shape \eqn{[\dots \times 4]}
specifying one or more 3D rotations in unit quaternion representation.}

\item{\code{extrinsic_or_intrinsic}}{A character string specifying the
coordinate frame in which the Tait-Bryan angles are expressed. Choices
are either \code{"extrinsic"} (fixed frame) or \code{"intrinsic"} (moving frame).
Defaults to \code{"extrinsic"}.}

\item{\code{order}}{A character string specifying the order of the rotation
composition around the three axes of the chosen coordinate frame.
Choices are either \code{"xyz"} or \code{"zyx"}. Defaults to \code{"zyx"}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of shape \eqn{[\dots \times 3]} storing the
corresponding Tait-Bryan angle representations.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$tait_bryan_angles_from_quaternion(c(1, rep(0, 3)))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpecialOrthogonal3Vectors-tait_bryan_angles_from_rotation_vector"></a>}}
\if{latex}{\out{\hypertarget{method-SpecialOrthogonal3Vectors-tait_bryan_angles_from_rotation_vector}{}}}
\subsection{Method \code{tait_bryan_angles_from_rotation_vector()}}{
Converts a 3D rotation from axis-angle to Tait-Bryan angle
representation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpecialOrthogonal3Vectors$tait_bryan_angles_from_rotation_vector(
  rot_vec,
  extrinsic_or_intrinsic = "extrinsic",
  order = "zyx"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rot_vec}}{A numeric array of shape \eqn{[\dots \times 3]} specifying
one or more 3D rotations in axis-angle representation.}

\item{\code{extrinsic_or_intrinsic}}{A character string specifying the
coordinate frame in which the Tait-Bryan angles are expressed. Choices
are either \code{"extrinsic"} (fixed frame) or \code{"intrinsic"} (moving frame).
Defaults to \code{"extrinsic"}.}

\item{\code{order}}{A character string specifying the order of the rotation
composition around the three axes of the chosen coordinate frame.
Choices are either \code{"xyz"} or \code{"zyx"}. Defaults to \code{"zyx"}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of shape \eqn{[\dots \times 3]} storing the
corresponding Tait-Bryan angle representations.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$tait_bryan_angles_from_rotation_vector(rep(0, 3))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpecialOrthogonal3Vectors-random_uniform"></a>}}
\if{latex}{\out{\hypertarget{method-SpecialOrthogonal3Vectors-random_uniform}{}}}
\subsection{Method \code{random_uniform()}}{
Samples in \eqn{\mathrm{SO}(3)} from a uniform distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpecialOrthogonal3Vectors$random_uniform(n_samples = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n_samples}}{An integer value specifying the sample size. Defaults to
\code{1L}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of shape \eqn{[\dots \times 3]} storing a sample
of 3D rotations in axis-angle representation uniformly sampled in
\eqn{\mathrm{SO}(3)}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3, point_type = "vector")
  so3$random_uniform()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpecialOrthogonal3Vectors-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SpecialOrthogonal3Vectors-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpecialOrthogonal3Vectors$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
