% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/special-orthogonal.R
\name{SpecialOrthogonalMatrices}
\alias{SpecialOrthogonalMatrices}
\title{Abstract Class for Special Orthogonal Groups in Matrix Representation}
\description{
Class for special orthogonal groups in matrix representation.
}
\examples{

## ------------------------------------------------
## Method `SpecialOrthogonalMatrices$belongs`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3)
  so3$belongs(diag(1, 3))
}

## ------------------------------------------------
## Method `SpecialOrthogonalMatrices$projection`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(3)
  so3$projection(diag(1, 3))
}
}
\seealso{
Other special orthogonal classes: 
\code{\link{SpecialOrthogonal2Vectors}},
\code{\link{SpecialOrthogonal3Vectors}},
\code{\link{SpecialOrthogonal}()}
}
\author{
Nicolas Guigui and Nina Miolane
}
\concept{special orthogonal classes}
\keyword{internal}
\section{Super classes}{
\code{rgeomstats::PythonClass} -> \code{\link[rgeomstats:Manifold]{rgeomstats::Manifold}} -> \code{\link[rgeomstats:MatrixLieGroup]{rgeomstats::MatrixLieGroup}} -> \code{SpecialOrthogonalMatrices}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{bi_invariant_metric}}{An object of class \code{BiInvariantMetric}
specifying the metric to equip the manifold with.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SpecialOrthogonalMatrices-new}{\code{SpecialOrthogonalMatrices$new()}}
\item \href{#method-SpecialOrthogonalMatrices-belongs}{\code{SpecialOrthogonalMatrices$belongs()}}
\item \href{#method-SpecialOrthogonalMatrices-intrinsic_to_extrinsic_coords}{\code{SpecialOrthogonalMatrices$intrinsic_to_extrinsic_coords()}}
\item \href{#method-SpecialOrthogonalMatrices-extrinsic_to_intrinsic_coords}{\code{SpecialOrthogonalMatrices$extrinsic_to_intrinsic_coords()}}
\item \href{#method-SpecialOrthogonalMatrices-projection}{\code{SpecialOrthogonalMatrices$projection()}}
\item \href{#method-SpecialOrthogonalMatrices-clone}{\code{SpecialOrthogonalMatrices$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgeomstats/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgeomstats::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgeomstats/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgeomstats::PythonClass$set_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="is_tangent"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-is_tangent'><code>rgeomstats::Manifold$is_tangent()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="random_point"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-random_point'><code>rgeomstats::Manifold$random_point()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="random_tangent_vec"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-random_tangent_vec'><code>rgeomstats::Manifold$random_tangent_vec()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="regularize"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-regularize'><code>rgeomstats::Manifold$regularize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="set_metric"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-set_metric'><code>rgeomstats::Manifold$set_metric()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="to_tangent"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-to_tangent'><code>rgeomstats::Manifold$to_tangent()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="MatrixLieGroup" data-id="compose"><a href='../../rgeomstats/html/MatrixLieGroup.html#method-MatrixLieGroup-compose'><code>rgeomstats::MatrixLieGroup$compose()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="MatrixLieGroup" data-id="exp"><a href='../../rgeomstats/html/MatrixLieGroup.html#method-MatrixLieGroup-exp'><code>rgeomstats::MatrixLieGroup$exp()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="MatrixLieGroup" data-id="get_identity"><a href='../../rgeomstats/html/MatrixLieGroup.html#method-MatrixLieGroup-get_identity'><code>rgeomstats::MatrixLieGroup$get_identity()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="MatrixLieGroup" data-id="inverse"><a href='../../rgeomstats/html/MatrixLieGroup.html#method-MatrixLieGroup-inverse'><code>rgeomstats::MatrixLieGroup$inverse()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="MatrixLieGroup" data-id="lie_bracket"><a href='../../rgeomstats/html/MatrixLieGroup.html#method-MatrixLieGroup-lie_bracket'><code>rgeomstats::MatrixLieGroup$lie_bracket()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="MatrixLieGroup" data-id="log"><a href='../../rgeomstats/html/MatrixLieGroup.html#method-MatrixLieGroup-log'><code>rgeomstats::MatrixLieGroup$log()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="MatrixLieGroup" data-id="tangent_translation_map"><a href='../../rgeomstats/html/MatrixLieGroup.html#method-MatrixLieGroup-tangent_translation_map'><code>rgeomstats::MatrixLieGroup$tangent_translation_map()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpecialOrthogonalMatrices-new"></a>}}
\if{latex}{\out{\hypertarget{method-SpecialOrthogonalMatrices-new}{}}}
\subsection{Method \code{new()}}{
The \code{\link{SpecialOrthogonalMatrices}} class constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpecialOrthogonalMatrices$new(n, ..., py_cls = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{An integer value specifying the number of rows and columns of
the matrices.}

\item{\code{...}}{Extra arguments to be passed to parent class constructors. See
\code{\link{MatrixLieAlgebra}}, \code{\link{LevelSet}} and \code{\link{Manifold}} classes.}

\item{\code{py_cls}}{A Python object of class \code{SpecialOrthogonalMatrices}.
Defaults to \code{NULL} in which case it is instantiated on the fly using
the other input arguments.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \code{\link{SpecialOrthogonalMatrices}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpecialOrthogonalMatrices-belongs"></a>}}
\if{latex}{\out{\hypertarget{method-SpecialOrthogonalMatrices-belongs}{}}}
\subsection{Method \code{belongs()}}{
Evaluates if a point belongs to the manifold.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpecialOrthogonalMatrices$belongs(point, atol = gs$backend$atol)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{point}}{A numeric array of shape \eqn{[\dots \times
\{\mathrm{dim}\}]} specifying one or more points to be checked.}

\item{\code{atol}}{A numeric value specifying the absolute tolerance for
checking. Defaults to \code{gs$backend$atol}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A boolean value or vector storing whether the input points belong
to the manifold.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3)
  so3$belongs(diag(1, 3))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpecialOrthogonalMatrices-intrinsic_to_extrinsic_coords"></a>}}
\if{latex}{\out{\hypertarget{method-SpecialOrthogonalMatrices-intrinsic_to_extrinsic_coords}{}}}
\subsection{Method \code{intrinsic_to_extrinsic_coords()}}{
Converts from intrinsic to extrinsic coordinates.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpecialOrthogonalMatrices$intrinsic_to_extrinsic_coords(point_intrinsic)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{point_intrinsic}}{A numeric array of shape \eqn{[\dots \times \{
  \mathrm{dim} \}]} specifying one or more points on the embedded
manifold in intrinsic coordinates.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of shape \eqn{[\dots \times \{
  \mathrm{dim_embedding} \}]} storing the same points on the embedded
manifold in extrinsic coordinates.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpecialOrthogonalMatrices-extrinsic_to_intrinsic_coords"></a>}}
\if{latex}{\out{\hypertarget{method-SpecialOrthogonalMatrices-extrinsic_to_intrinsic_coords}{}}}
\subsection{Method \code{extrinsic_to_intrinsic_coords()}}{
Converts from extrinsic to intrinsic coordinates.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpecialOrthogonalMatrices$extrinsic_to_intrinsic_coords(point_extrinsic)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{point_extrinsic}}{A numeric array of shape \eqn{[\dots \times \{
  \mathrm{dim_embedding} \}]} specifying one or more points on the
embedded manifold in extrinsic coordinates.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of shape \eqn{[\dots \times \{ \mathrm{dim} \}]}
storing the same points on the embedded manifold in intrinsic
coordinates.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpecialOrthogonalMatrices-projection"></a>}}
\if{latex}{\out{\hypertarget{method-SpecialOrthogonalMatrices-projection}{}}}
\subsection{Method \code{projection()}}{
Project a matrix on \eqn{\mathrm{SO}(n)} by minimizing the
Frobenius norm.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpecialOrthogonalMatrices$projection(point)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{point}}{A numeric array of shape \eqn{[\dots \times n \times n]}
specifying one or more matrices.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of the same shape storing the projected matrices.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(3)
  so3$projection(diag(1, 3))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpecialOrthogonalMatrices-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SpecialOrthogonalMatrices-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpecialOrthogonalMatrices$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
