% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vector-space.R
\name{VectorSpace}
\alias{VectorSpace}
\title{Abstract Class for Vector Space Manifolds}
\description{
Abstract class for vector spaces.
}
\author{
Nicolas Guigui and Nina Miolane
}
\keyword{internal}
\section{Super classes}{
\code{rgeomstats::PythonClass} -> \code{\link[rgeomstats:Manifold]{rgeomstats::Manifold}} -> \code{VectorSpace}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{basis}}{Basis of the vector space.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-VectorSpace-new}{\code{VectorSpace$new()}}
\item \href{#method-VectorSpace-projection}{\code{VectorSpace$projection()}}
\item \href{#method-VectorSpace-clone}{\code{VectorSpace$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgeomstats/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgeomstats::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgeomstats/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgeomstats::PythonClass$set_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="belongs"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-belongs'><code>rgeomstats::Manifold$belongs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="is_tangent"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-is_tangent'><code>rgeomstats::Manifold$is_tangent()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="random_point"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-random_point'><code>rgeomstats::Manifold$random_point()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="random_tangent_vec"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-random_tangent_vec'><code>rgeomstats::Manifold$random_tangent_vec()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="regularize"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-regularize'><code>rgeomstats::Manifold$regularize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="set_metric"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-set_metric'><code>rgeomstats::Manifold$set_metric()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="to_tangent"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-to_tangent'><code>rgeomstats::Manifold$to_tangent()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VectorSpace-new"></a>}}
\if{latex}{\out{\hypertarget{method-VectorSpace-new}{}}}
\subsection{Method \code{new()}}{
The \code{\link{VectorSpace}} class constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VectorSpace$new(shape, ..., py_cls = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{shape}}{An integer vector specifying the shape of one element of the
manifold. Defaults to \code{NULL}.}

\item{\code{...}}{Extra arguments to be passed to parent class constructors. See
\code{\link{Manifold}} class.}

\item{\code{py_cls}}{A Python object of class \code{VectorSpace}. Defaults to \code{NULL}
in which case it is instantiated on the fly using the other input
arguments.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \code{\link{VectorSpace}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VectorSpace-projection"></a>}}
\if{latex}{\out{\hypertarget{method-VectorSpace-projection}{}}}
\subsection{Method \code{projection()}}{
Project a point onto the vector space.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VectorSpace$projection(point)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{point}}{A numeric array of shape \code{dim} specifying a vector in the
ambient space onto the manifold.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This method is for compatibility and returns \code{point}. \code{point}
should have the right shape.
}

\subsection{Returns}{
A numeric array of shape \code{dim} storing the input \code{vector}
projected onto the manifold.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VectorSpace-clone"></a>}}
\if{latex}{\out{\hypertarget{method-VectorSpace-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VectorSpace$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
