% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timescales.R
\name{BCADtoDelta14C}
\alias{BCADtoDelta14C}
\title{Find the Delta14C and error belonging to a cal BC/AD age.}
\usage{
BCADtoDelta14C(
  x,
  zero = TRUE,
  cc = 1,
  postbomb = FALSE,
  rule = 1,
  cc.dir = NULL,
  thiscurve = NULL,
  roundby = NA
)
}
\arguments{
\item{x}{The cal BC/AD year.}

\item{zero}{Whether or not zero BC/AD should be included. Defaults to \code{zero=TRUE}.}

\item{cc}{calibration curve (see \code{caldist()}).}

\item{postbomb}{Whether or not to use a postbomb curve (see \code{caldist()}).}

\item{rule}{How should R's approx function deal with extrapolation. If \code{rule=1}, the default, then NAs are returned for such points and if it is 2, the value at the closest data extreme is used.}

\item{cc.dir}{Directory of the calibration curves. Defaults to where the package's files are stored (system.file), but can be set to, e.g., \code{cc.dir="curves"}.}

\item{thiscurve}{As an alternative to providing cc and/or postbomb, the data of a specific curve can be provided (3 columns: cal BP, C14 age, error).}

\item{roundby}{Amount of decimals required for the output. Defaults to \code{roundby=NA}, no rounding.}
}
\value{
The calibration-curve 14C year belonging to the entered cal BC/AD age.
}
\description{
Given a calendar age, the calibration curve (default cc=1) is interpolated and the corresponding Delta14C value and error are returned.
}
\details{
Interpolation is used, and values outside the calibration curve are given as NA. For negative cal BP ages, a postbomb curve will have to be provided.
}
\examples{
  BCADtoDelta14C(1900)
}
\author{
Maarten Blaauw
}
