% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timescales.R
\name{Delta14CtoC14}
\alias{Delta14CtoC14}
\title{Transform Delta14C into C14 age}
\usage{
Delta14CtoC14(Delta14C, er = NULL, t, roundby = NA)
}
\arguments{
\item{Delta14C}{The Delta14C value to translate}

\item{er}{Reported error of the Delta14C. Returns just the mean if left empty.}

\item{t}{the cal BP age}

\item{roundby}{Amount of decimals required for the output. Defaults to \code{roundby=NA}, no rounding.}
}
\value{
The corresponding C14 age
}
\description{
Transform Delta14C into C14 age
}
\details{
As explained by Heaton et al. 2020 (Radiocarbon), 14C measurements are commonly expressed in
three domains: Delta14C, F14C and the radiocarbon age. This function translates Delta14C, the historical level of Delta14C in the year t cal BP, to C14 ages. Note that per convention, this function uses the Cambridge half-life, not the Libby half-life.
}
\examples{
  Delta14CtoC14(-10, 1, 238)
}
