% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kde_d.R
\name{kde_d}
\alias{kde_d}
\title{Multivariate kernel density}
\usage{
kde_d(x.obs, x.new = NULL, h, stud = FALSE)
}
\arguments{
\item{x.obs}{Training (observed) data (n1 by d matrix, d>=2)}

\item{x.new}{Evaluation data (n2 by d matrix, d>=2); default to x.obs}

\item{h}{Bandwidth (d vector)}

\item{stud}{Indicator for whether data are studentized; default to FALSE}
}
\value{
Density evaluated at x.new
}
\description{
Multivariate kernel density
}
\details{
For multivariate distributions, bandwidth is calculated for studentized data.
}
\examples{
x=matrix(rnorm(200),ncol=2)
x.new=matrix(rnorm(100),ncol=2)
h=c(1,1)
f=kde_d(x.new=x.new,x.obs=x,h=h)
}
\references{
Wu, Ximing (2019), "Robust Likelihood Cross Validation for Kernel Density Estimation," Journal of Business and Economic Statistics, 37(4): 761-770.
}
\author{
Ximing Wu \email{xwu@tamu.edu}
}
