% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KMClass.R
\name{KM}
\alias{KM}
\title{Create an \code{KM} Object}
\usage{
KM(
  formula = ~1,
  design,
  response,
  covtype = c("matern5_2", "gauss", "matern3_2", "exp"),
  coef.trend = NULL,
  coef.cov = NULL,
  coef.var = NULL,
  nugget = NULL,
  nugget.estim = FALSE,
  noise.var = NULL,
  estim.method = c("MLE", "LOO"),
  penalty = NULL,
  optim.method = "BFGS",
  lower = NULL,
  upper = NULL,
  parinit = NULL,
  multistart = 1,
  control = NULL,
  gr = TRUE,
  iso = FALSE,
  scaling = FALSE,
  knots = NULL,
  kernel = NULL,
  ...
)
}
\arguments{
\item{formula}{R formula object to setup the linear trend in
Universal Kriging. Supports \code{~ 1}, ~. and \code{~ .^2}.}

\item{design}{Data frame. The design of experiments.}

\item{response}{Vector of output values.}

\item{covtype}{Covariance structure. For now all the kernels are
tensor product kernels.}

\item{coef.trend}{Optional value for a fixed vector of trend
coefficients.  If given, no optimization is done.}

\item{coef.cov}{Optional value for a fixed correlation range
value. If given, no optimization is done.}

\item{coef.var}{Optional value for a fixed variance. If given, no
optimization is done.}

\item{nugget, nugget.estim, noise.var}{Not implemented yet.}

\item{estim.method}{Estimation criterion. \code{"MLE"} for
Maximum-Likelihood or \code{"LOO"} for Leave-One-Out
cross-validation.}

\item{penalty}{Not implemented yet.}

\item{optim.method}{Optimization algorithm used in the
optimization of the objective given in
\code{estim.method}. Supports \code{"BFGS"}.}

\item{lower, upper}{Not implemented yet.}

\item{parinit}{Initial values for the correlation ranges which
will be optimized using \code{optim.method}.}

\item{multistart, control, gr, iso}{Not implemented yet.}

\item{scaling, knots, kernel, }{Not implemented yet.}

\item{...}{Ignored.}
}
\value{
A KM object. See \bold{Details}.
}
\description{
Create an object of S4 class \code{"KM"} similar to a
\code{km} object in the \pkg{DiceKriging} package.
}
\details{
The class \code{"KM"} extends the \code{"km"} class of the
\pkg{DiceKriging} package, hence has all slots of \code{"km"}. It
also has an extra slot \code{"Kriging"} slot which contains a copy
of the original object.
}
\examples{
# a 16-points factorial design, and the corresponding response
d <- 2; n <- 16
design.fact <- as.matrix(expand.grid(x1 = seq(0, 1, length = 4),
                                     x2 = seq(0, 1, length = 4)))
y <- apply(design.fact, 1, DiceKriging::branin) 

# Using `km` from DiceKriging and a similar `KM` object 
# kriging model 1 : matern5_2 covariance structure, no trend, no nugget effect
km1 <- DiceKriging::km(design = design.fact, response = y, covtype = "gauss",
                       parinit = c(.5, 1), control = list(trace = FALSE))
KM1 <- KM(design = design.fact, response = y, covtype = "gauss",
          parinit = c(.5, 1))

}
\seealso{
\code{\link[DiceKriging]{km}} in the \pkg{DiceKriging}
    package for more details on the slots.
}
\author{
Yann Richet \email{yann.richet@asnr.fr}
}
