# Copyright 2024-2024 Steven E. Pav. All Rights Reserved.
# Author: Steven E. Pav
#
# This file is part of rnnmf.
#
# rnnmf is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# rnnmf is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with rnnmf.  If not, see <http://www.gnu.org/licenses/>.

# Created: 2024-08-17
# Copyright: Steven E. Pav, 2024
# Author: Steven E. Pav
# Comments: Steven E. Pav

#' Regularized Non-negative Matrix Factorization.
#' 
#' @section Legal Mumbo Jumbo:
#'
#' rnnmf is distributed in the hope that it will be useful,
#' but WITHOUT ANY WARRANTY; without even the implied warranty of
#' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#' GNU Lesser General Public License for more details.
#'
#' @template etc
#' @template poc
#'
#' @template ref-leeseung
#' @template ref-pav
#' @references
#'
#' Pav, Steven E. "System and method for unmixing spectroscopic observations with nonnegative 
#' matrix factorization." US Patent 8140272, 2012.
#' \url{https://patentscope.wipo.int/search/en/detail.jsf?docId=US42758160}
#'
#' @name rnnmf
#' @rdname rnnmf
#' @docType package
#' @title regularized non-negative matrix factorization
#' @keywords package
#' @keywords internal
#' @note
#' 
#' This package is maintained as a hobby. 
#'
"_PACKAGE"

#' @title News for package 'rnnmf':
#'
#' @description 
#'
#' News for package \sQuote{rnnmf}
#'
#' \newcommand{\CRANpkg}{\href{https://cran.r-project.org/package=#1}{\pkg{#1}}}
#' \newcommand{\rnnmf}{\CRANpkg{rnnmf}}
#'
#' @section \rnnmf{} Initial Version 0.3.0 (2024-10-30) :
#' \itemize{
#' \item first CRAN release.
#' \item changed name from rnmf to rnnmf.
#' }
#'
#' @name rnnmf-NEWS
#' @rdname NEWS
NULL

#for vim modeline: (do not edit)
# vim:fdm=marker:fmr=FOLDUP,UNFOLD:cms=#%s:syn=r:ft=r
