% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Datasimulation.R
\name{simulate_pharma_batches}
\alias{simulate_pharma_batches}
\title{Simulate Pharmaceutical Manufacturing Batches (Realistic Variability)}
\usage{
simulate_pharma_batches(obs_per_batch = 30, seed = 780)
}
\arguments{
\item{obs_per_batch}{Integer. Number of observations per batch. Default is 30.}

\item{seed}{Optional integer. If provided, sets a random seed for reproducibility.}
}
\value{
A data frame with 450 observations and the following columns:
\describe{
\item{Batch}{Factor. Batch identifier (Batch_1 to Batch_15).}
\item{Phase}{Factor. Phase of the process: "Phase 1" or "Phase 2".}
\item{Status}{Factor. Control status: "Under Control" or "Out of Control".}
\item{Concentration, Humidity, Dissolution, Density}{Numeric quality control variables.}
}
}
\description{
Simulates pharmaceutical manufacturing batches across two phases.
Phase 1 includes 10 under-control batches, each with natural variability in mean and covariance.
Phase 2 includes 2 clean under-control batches and 3 out-of-control batches
with shifted mean, increased dispersion, and moderate contamination.
}
\details{
The simulated data includes four quality control variables: Concentration, Humidity, Dissolution, and Density.
}
