% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClass.R
\docType{class}
\name{rlmerMod-class}
\alias{rlmerMod-class}
\alias{coef.rlmerMod}
\alias{deviance.rlmerMod}
\alias{extractAIC.rlmerMod}
\alias{family.rlmerMod}
\alias{fitted.rlmerMod}
\alias{fixef.rlmerMod}
\alias{formula.rlmerMod}
\alias{isGLMM.rlmerMod}
\alias{isLMM.rlmerMod}
\alias{isNLMM.rlmerMod}
\alias{isREML.rlmerMod}
\alias{logLik.rlmerMod}
\alias{model.frame.rlmerMod}
\alias{model.matrix.rlmerMod}
\alias{nobs.rlmerMod}
\alias{predict.rlmerMod}
\alias{print.rlmerMod}
\alias{print.summary.rlmer}
\alias{print.VarCorr.rlmerMod}
\alias{ranef.rlmerMod}
\alias{resid.rlmerMod}
\alias{sigma.rlmerMod}
\alias{show.rlmerMod}
\alias{show,rlmerMod-method}
\alias{show.summary.rlmerMod}
\alias{summary.rlmerMod}
\alias{summary.summary.rlmerMod}
\alias{terms.rlmerMod}
\alias{update.rlmerMod}
\alias{VarCorr.rlmerMod}
\alias{VarCorr.summary.rlmerMod}
\alias{vcov.rlmerMod}
\alias{vcov.summary.rlmerMod}
\alias{weights.rlmerMod}
\title{rlmerMod Class}
\description{
Class "rlmerMod" of Robustly Fitted Mixed-Effect Models
}
\details{
A robust mixed-effects model as returned by \code{\link{rlmer}}.
}
\section{Objects from the Class}{
 Objects are created by calls to
  \code{\link{rlmer}}.
}

\section{Methods}{
 Almost all methods available from objects returned from
  \code{\link[lme4]{lmer}} are also available for objects returned by
  \code{\link{rlmer}}. They usage is the same.

  It follows a list of some the methods that are exported by this package:

\itemize{
\item \code{\link[stats]{coef}}
\item \code{\link[stats]{deviance}} (disabled, see below)
\item \code{\link[stats]{extractAIC}} (disabled, see below)
\item \code{\link[stats]{family}}
\item \code{\link[stats]{fitted}}
\item \code{\link[lme4:fixef.merMod]{fixef}}
\item \code{\link[stats]{formula}}
\item \code{\link{getInfo}}
\item \code{\link[lme4]{isGLMM}}
\item \code{\link[lme4]{isLMM}}
\item \code{\link[lme4]{isNLMM}}
\item \code{\link[lme4]{isREML}}
\item \code{\link[stats]{logLik}} (disabled, see below)
\item \code{\link[stats]{model.frame}}
\item \code{\link[stats]{model.matrix}}
\item \code{\link[lme4]{nobs}}
\item \code{\link[=plot.rlmerMod]{plot}}
\item \code{\link[lme4:predict.merMod]{predict}}
\item \code{\link[lme4:ranef.merMod]{ranef}} (only partially implemented)
\item \code{\link[=residuals.rlmerMod]{residuals}}
\item \code{\link[lme4]{sigma}}
\item \code{\link[base]{summary}}
\item \code{\link[stats]{terms}}
\item \code{\link[stats]{update}}
\item \code{\link[lme4:VarCorr.merMod]{VarCorr}}
\item \code{\link[lme4:vcov.merMod]{vcov}}
\item \code{\link[stats]{weights}}
}
}

\section{Disabled methods}{
 A log likelihood or even a pseudo log likelihood
  is not defined for the robust estimates returned by \code{\link{rlmer}}.
  Methods that depend on the log likelihood are therefore not available. For
  this reason the methods \code{deviance}, \code{extractAIC} and
  \code{logLik} stop with an error if they are called.
}

\examples{

showClass("rlmerMod")

## convert an object of type 'lmerMod' to 'rlmerMod'
## to use the methods provided by robustlmm
fm <- lmer(Yield ~ (1|Batch), Dyestuff)
rfm <- as(fm, "rlmerMod")
compare(fm, rfm)

}
\seealso{
\code{\link{rlmer}}; corresponding class in package \code{lme4}:
  \code{\link[lme4:merMod-class]{merMod}}
}
\keyword{classes}
