% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rob_summary.R
\name{rob_summary}
\alias{rob_summary}
\title{Produce summary weighted barplots of risk-of-bias assessments.}
\usage{
rob_summary(data, tool, overall = FALSE, weighted = TRUE,
  colour = "cochrane", quiet = FALSE)
}
\arguments{
\item{data}{A dataframe containing summary (domain) level risk-of-bias assessments, with the first column containing the study details, the second column containing the first domain of your assessments, and the final column containing a weight to assign to each study. The function assumes that the data includes a column for overall risk-of-bias. For example, a ROB2.0 dataset would have 8 columns (1 for study details, 5 for domain level judgments, 1 for overall judgements, and 1 for weights, in that order).}

\item{tool}{The risk of bias assessment tool used. RoB2.0 (tool='ROB2'), ROBINS-I (tool='ROBINS-I'), and QUADAS-2 (tool='QUADAS-2') are currently supported.}

\item{overall}{An option to include a bar for overall risk-of-bias in the figure. Default is FALSE.}

\item{weighted}{An option to specify whether weights should be used in the barplot. Default is TRUE, in line with current Cochrane Collaboration guidance.}

\item{colour}{An argument to specify the colour scheme for the plot. Default is 'cochrane' which used the ubiquitous Cochrane colours, while a preset option for a colour-blind friendly palette is also available (colour = 'colourblind').}

\item{quiet}{An option to quietly produce the plot without displaying it.}
}
\value{
Risk of bias assessment barplot figure.
}
\description{
A function to convert standard risk-of-bias output to tidy data and plot a summary barplot.
}
\examples{

data <- data.frame(stringsAsFactors=FALSE,
                   Study = c("Study 1", "Study 2"),
                   D1 = c("Low", "Some concerns"),
                   D2 = c("Low", "Low"),
                   D3 = c("Low", "Low"),
                   D4 = c("Low", "Low"),
                   D5 = c("Low", "Low"),
                   Overall = c("Low", "Low"),
                   Weight = c(33.33333333, 33.33333333)
                   )

rob_summary(data, "ROB2")

}
