% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commands.R
\name{rockr.command}
\alias{rockr.command}
\title{Get an asynchronous command}
\usage{
rockr.command(conn, id, wait = FALSE)
}
\arguments{
\item{conn}{A rockr connection object.}

\item{id}{R command ID.}

\item{wait}{Wait for the command to complete.}
}
\value{
The command object.
}
\description{
Get an asynchronous R commands in the remote R session.
}
\examples{
\dontrun{
conn <- rockr.connect(username='user', password='password',
                      url='https://rocker-demo.obiba.org')
rockr.open(conn)
rockr.command(conn, '1234')
rockr.close(conn)
}
}
\seealso{
Other command functions: 
\code{\link{rockr.command_result}()},
\code{\link{rockr.command_rm}()},
\code{\link{rockr.commands_rm}()},
\code{\link{rockr.commands}()}
}
\concept{command functions}
