% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_birth_year.R
\name{get_birth_year}
\alias{get_birth_year}
\title{Extract Year of Birth from the Personal Numeric Code}
\usage{
get_birth_year(cnp)
}
\arguments{
\item{cnp}{a 13-digit number (or a vector of 13-digit numbers) representing
the Personal Numeric Code - CNP}
}
\value{
a character vector representing the year of birth (the century is
unknown for non-natives)
}
\description{
This function infers the year of birth based on the code for sex - which
is also indicative of the century of birth - and the \code{AA} component denoting
the final 2 digits of the birth year. The year is returned as string,
especially since for residents not born in Romania, there might be two
possible valid values for the birth year - in this case the year is returned
as \code{"__yy"}
}
\examples{
get_birth_year(1940616346114)
get_birth_year(7041218318525)
}
