% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geolayer.R
\name{get_variables}
\alias{get_variables}
\alias{get_variables.geolayer}
\title{Get the variables layer}
\usage{
get_variables(gl)

\method{get_variables}{geolayer}(gl)
}
\arguments{
\item{gl}{A \code{geolayer} object.}
}
\value{
A \code{tibble} object.
}
\description{
The variables layer includes the names and description through various fields
of the variables contained in the geolayer.
}
\details{
The way to select the variables we want to work with is to filter this layer
and subsequently set it as the object's variables layer using the \code{set_variables()}
function.
}
\examples{

gl <- mrs_db_geo |>
  as_geolayer()

v <- gl |>
  get_variables()

}
\seealso{
Other query functions: 
\code{\link{as_GeoPackage}()},
\code{\link{as_geolayer}()},
\code{\link{filter_dimension}()},
\code{\link{get_layer}()},
\code{\link{get_variable_description}()},
\code{\link{run_query}()},
\code{\link{select_dimension}()},
\code{\link{select_fact}()},
\code{\link{set_layer}()},
\code{\link{set_variables}()},
\code{\link{star_query}()}
}
\concept{query functions}
