% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{mrs_age_schema_rpd}
\alias{mrs_age_schema_rpd}
\title{Star schema for Mortality Reporting System by Age with additional dates}
\format{
A \code{star_schema} object.
}
\usage{
mrs_age_schema_rpd
}
\description{
Definition of schemas for facts and dimensions for the Mortality Reporting System
considering the cause classification with additional dates to be used as role
playing dimensions..
}
\examples{
# Defined by:

mrs_age_schema_rpd <- star_schema() |>
  define_facts(fact_schema(
    name = "mrs_age",
    measures = c(
      "Deaths"
    )
  )) |>
  define_dimension(dimension_schema(
    name = "When",
    attributes = c(
      "Year",
      "WEEK",
      "Week Ending Date"
    )
  )) |>
  define_dimension(dimension_schema(
    name = "When Available",
    attributes = c(
      "Data Availability Year",
      "Data Availability Week",
      "Data Availability Date"
    )
  )) |>
  define_dimension(dimension_schema(
    name = "When Arrived",
    attributes = c(
      "Arrival Year",
      "Arrival Week",
      "Arrival Date"
    )
  )) |>
  define_dimension(dimension_schema(
    name = "Who",
    attributes = c(
      "Age Range"
    )
  )) |>
  define_dimension(dimension_schema(
    name = "where",
    attributes = c(
      "REGION",
      "State",
      "City"
    )
  ))

}
\seealso{
\code{\link{ft_age_rpd}}

Other mrs example schema: 
\code{\link{mrs_age_schema}},
\code{\link{mrs_cause_schema}},
\code{\link{mrs_cause_schema_rpd}}
}
\concept{mrs example schema}
\keyword{datasets}
