% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_data.R
\name{score_data}
\alias{score_data}
\title{Create propensity scores using a logistic or probit regression model}
\usage{
score_data(reduced_data, model_type, match_on, fm, treat, tm, entry, id)
}
\arguments{
\item{reduced_data}{Dataframe of reduced treatment and comparison data.
See output of reduce_data().}

\item{model_type}{Use logistic regression ("logistic") or "probit"
regression ("probit") to estimate the predicted probability of participating}

\item{match_on}{Match on estimated propensity score ("pscore") or logit of
estimated propensity score ("logit").}

\item{fm}{A \code{\link[stats]{formula}} in the form
\code{treat ~ x1 + x2 ...} where \code{treat} is a binary treatment
indicator (Treat = 1, Control = 0) and \code{x1} and \code{x2} are
pre-treatment covariates. Both the treatment indicator and
pre-treatment covariates must be contained in the input dataset.}

\item{treat}{String for name of treatment variable in data.}

\item{tm}{String for time period indicator variable name in data.}

\item{entry}{String for name of time period in which the participant
enrolled in the intervention (in the same units as the tm variable).}

\item{id}{String for individual id variable name in data.}
}
\value{
A copy of reduced_data input with added propensity scores
}
\description{
Create propensity scores using a logistic or probit regression model
}
\examples{
\dontrun{
data(package="rollmatch", "rem_synthdata_small")
fm <- as.formula(treat ~ qtr_pmt + age + is_male + is_white)
reduced_data <- reduce_data(data = rem_synthdata_small, treat = "treat",
                            tm = "quarter", entry = "entry_q",
                            id = "indiv_id", lookback = 1)
scored_data <- score_data(reduced_data = reduced_data,
                          model_type = "logistic", match_on = "logit",
                          fm = fm, treat = "treat", tm = "quarter",
                          entry = "entry_q", id = "indiv_id")
head(scored_data)
}

}
