% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file-details.R
\name{get_file_details}
\alias{get_file_details}
\title{Retrieve details for a given file from a specific Rapid7 Open Data study}
\usage{
get_file_details(study_name, file_name, include_download_link = FALSE,
  rapid7_opendata_api_key = rapid7_api_key())
}
\arguments{
\item{study_name}{A valid study name. This should be a value from the field
\code{uniqid} in the result from a call to \code{\link[=list_studies]{list_studies()}}. Current known,
good values are "\code{sonar.national_exposure}", "\code{heisenberg.cowrie}",
"\code{sonar.atg_10001_tcp}", "\code{sonar.http}", "\code{sonar.ssl}", "\code{sonar.tcp}",
"\code{sonar.moressl}", "\code{sonar.rdns_v2}", "\code{sonar.udp}", "\code{sonar.cio}",
"\code{sonar.https}", "\code{sonar.fdns}", "\code{sonar.rdns}",  and "\code{sonar.fdns_v2}".}

\item{file_name}{A valid file name from a given \code{study_name}.}

\item{include_download_link}{if \code{TRUE}, have the API generate a download link
along with the metadata and include it in a \code{url} field in the data frame.
\strong{NOTE} that \strong{each use} of the this parameter counts towards the Rapid7
Open Data daily download quota. For that reason, the default value is
\code{FALSE}. Only set it to \code{TRUE} if you intend to start a download action
(e.g. using \code{\link[utils:download.file]{utils::download.file()}} with the result) shortly after
calling the function.}

\item{rapid7_opendata_api_key}{Your Rapid7 Open Data API key. The various
API interface function look for this key in \code{RAPID7_OPENDATA_API_KEY}.
You can manually provide this key and if the function is used interactively
and the key is not found, you will be prompted to enter the key.}
}
\value{
data frame
}
\description{
Retrieve details for a given file from a specific Rapid7 Open Data study
}
\examples{
try(
  get_file_details("sonar.fdns_v2", "2018-06-15-1529049662-fdns_aaaa.json.gz"),
  silent=TRUE
) -> details
}
