% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/examples_roclet.R
\name{examples_roclet}
\alias{examples_roclet}
\title{Roclet: check presence of \verb{@examples} in documentation for exported functions}
\usage{
examples_roclet()
}
\value{
A roclet to be used e.g. with \code{\link[roxygen2:roxygenize]{roxygen2::roxygenise()}}
}
\description{
This roclet checks presence of \verb{@example}/\verb{@examples}.

Generally you will not call this function directly
but will instead use \code{\link[roxygen2:roxygenize]{roxygen2::roxygenise()}} specifying this roclet.
}
\examples{
x <- "#' Summing two numbers\n#'\n#' @export\nf <- function(x, y) {\n   x + y\n}\n"
cat(x)
roxygen2::roc_proc_text(examples_roclet(), x)

}
\seealso{
Other roclets:
\code{\link{testthat_roclet}},
\code{\link{tinytest_roclet}},
\code{\link{param_roclet}},
\code{\link{return_roclet}},
\code{\link[roxygen2]{namespace_roclet}},
\code{\link[roxygen2]{rd_roclet}},
\code{\link[roxygen2]{vignette_roclet}}.

Other roclets: 
\code{\link{param_roclet}()},
\code{\link{return_roclet}()},
\code{\link{testthat_roclet}()},
\code{\link{tinytest_roclet}()}
}
\concept{roclets}
