% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/planes.R
\name{plane_score}
\alias{plane_score}
\title{Score PLANES components}
\usage{
plane_score(input, seed, components = "all", args = NULL, weights = NULL)
}
\arguments{
\item{input}{Input signal data to be scored; object must be one of \link[=to_signal]{forecast} or \link[=to_signal]{observed}}

\item{seed}{Prepared \link[=plane_seed]{seed}}

\item{components}{Character vector specifying component; must be either \code{"all"} or any combination of \code{"cover"}, \code{"diff"}, \code{"taper"}, \code{"trend"}, \code{"repeat"}, \code{"shape"}, and \code{"zero"}; default is \code{"all"} and will use all available components for the given signal}

\item{args}{Named list of arguments for component functions. List elements must be named to match the given component and arguments passed as a nested list (e.g., \code{args = list("trend" = list("sig_lvl" = 0.05))}). Default is \code{NULL} and defaults for all components will be used}

\item{weights}{Named vector with weights to be applied; default is \code{NULL} and all components will be equally weighted; if not \code{NULL} then the length of the vector must equal the number of components, with each component given a numeric weight (see Examples). Specified weights must be real numbers greater than or equal to 1.}
}
\value{
A \code{list} with scoring results for all locations.
}
\description{
This function wraps PLANES scoring for specified components across all locations in single step.
}
\examples{
\donttest{
## read in example observed data and prep observed signal
hosp <- read.csv(system.file("extdata/observed/hdgov_hosp_weekly.csv", package = "rplanes"))

hosp$date <- as.Date(hosp$date, format = "\%Y-\%m-\%d")
prepped_observed <- to_signal(hosp, outcome = "flu.admits", type = "observed", resolution = "weeks")

## read in example forecast and prep forecast signal
fp <- system.file("extdata/forecast/2022-10-31-SigSci-TSENS.csv", package = "rplanes")
prepped_forecast <- read_forecast(fp) \%>\%
  to_signal(., outcome = "flu.admits", type = "forecast", horizon = 4)

## prepare seed with cut date
prepped_seed <- plane_seed(prepped_observed, cut_date = "2022-10-29")

## run plane scoring with all components
plane_score(input = prepped_forecast, seed = prepped_seed)

## run plane scoring with select components
plane_score(input = prepped_forecast, seed = prepped_seed, components = c("cover","taper"))

## run plane scoring with all components and additional args
trend_args <- list("sig_lvl" = 0.05)
repeat_args <- list("prepend" = 4, "tolerance" = 8)
shape_args <- list("method" = "dtw")
comp_args <- list("trend" = trend_args, "repeat" = repeat_args, "shape" = shape_args)
plane_score(input = prepped_forecast, seed = prepped_seed, args = comp_args)

## run plane scoring with specific components and weights
comps <- c("cover", "taper", "diff")
wts <- c("cover" = 1.5, "taper" = 1, "diff" = 4)
plane_score(input = prepped_forecast, seed = prepped_seed, components = comps, weights = wts)

}
}
