% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/planes.R
\name{plane_zero}
\alias{plane_zero}
\title{Zero component}
\usage{
plane_zero(location, input, seed)
}
\arguments{
\item{location}{Character vector with location code; the location must appear in input and seed}

\item{input}{Input signal data to be scored; object must be one of \link[=to_signal]{forecast} or \link[=to_signal]{observed}}

\item{seed}{Prepared \link[=plane_seed]{seed}}
}
\value{
A \code{list} with the following values:
\itemize{
\item \strong{indicator}: Logical as to whether or not there are zeros in evaluated signal but not in seed data
}
}
\description{
This function checks for the presence of any value(s) equal to zero in the evaluated signal. If there are any zeros found, then the function assesses whether or not any zeros have been observed in the \link[=plane_seed]{seed} for the given location. If so, the function will consider the evaluated zero plausible and no flag will be raised (i.e., indicator returned as \code{FALSE}). If not, the function will consider the evaluated zero implausible and a flag will be raised (i.e., indicator returned as \code{TRUE}).
}
\examples{
## read in example observed data and prep observed signal
hosp <- read.csv(system.file("extdata/observed/hdgov_hosp_weekly.csv", package = "rplanes"))
hosp$date <- as.Date(hosp$date, format = "\%Y-\%m-\%d")
prepped_observed <- to_signal(hosp, outcome = "flu.admits", type = "observed", resolution = "weeks")

## read in example forecast and prep forecast signal
fp <- system.file("extdata/forecast/2022-10-31-SigSci-TSENS.csv", package = "rplanes")
prepped_forecast <- read_forecast(fp) \%>\%
  to_signal(., outcome = "flu.admits", type = "forecast", horizon = 4)

## prepare seed with cut date
prepped_seed <- plane_seed(prepped_observed, cut_date = "2022-10-29")

## run plane component
plane_zero(location = "10", input = prepped_forecast, seed = prepped_seed)
plane_zero(location = "51", input = prepped_forecast, seed = prepped_seed)

}
