% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subroutines.R
\name{density_h2o}
\alias{density_h2o}
\title{Density of water}
\usage{
density_h2o(tc, p)
}
\arguments{
\item{tc}{numeric, air temperature (tc), degrees C}

\item{p}{numeric, atmospheric pressure (p), Pa}
}
\value{
numeric, density of water, kg/m^3
}
\description{
Calculates the density of water as a function of temperature and atmospheric
pressure, using the Tumlirz Equation.
}
\examples{
 # Density of water at 20 degrees C and standard atmospheric pressure
 print(density_h2o(20, 101325))

}
\references{
F.H. Fisher and O.E Dial, Jr. (1975) Equation of state of
pure water and sea water, Tech. Rept., Marine Physical
Laboratory, San Diego, CA.
}
