% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialize.para.R
\name{initialize.para}
\alias{initialize.para}
\title{Initialization of Parameter Estimates}
\usage{
initialize.para(K, X, Y, ind0 = NULL,
                seed = NULL, km.nstart = 20, kmscale = FALSE, n.init = 100,
                commonvar = FALSE)
}
\arguments{
\item{K}{number of mixture components.}

\item{X}{n by p design matrix where n is the number of observations and
p is the number of predictors.}

\item{Y}{n by q response matrix where n is the number of observations and
q is the number of responses.}

\item{ind0}{vector of length n, specifying the initial assignment of the
mixture membership of n observations when there is prior information on
the membership. If `NULL', K-means clustering technique is used to assign
the membership for n observations. Default is `NULL'.}

\item{seed}{seed number for the reproducibility of results. Default is `NULL'.}

\item{km.nstart}{number of random sets considered to perform K-means
clustering. Only used for K-means clustering. Default is 20.}

\item{kmscale}{logical value, indicating whether Y is scaled prior to K-means
clustering. Only used for K-means clustering. Default is `FALSE'.}

\item{n.init}{number of initializations to try. Two methods for initial
clustering are used: K-means and random clustering.}

\item{commonvar}{logical value, indicating the homogeneity assumption of
variance-covariance matrices across K mixture components. Default is `FALSE'.}
}
\value{
\item{para}{array of length K. It consists of K lists, each of which contains
  initial estimates of membership probability, coefficient matrix, and variance-
  covariance matrix.}
}
\description{
`initialize.para' is used to initialize parameter estimates.
}
\examples{
#-----------------------------------------------------------#
# Simulation 1: Two Components Case
#-----------------------------------------------------------#
K2mod <- rrmix.sim.norm(K = 2, n = 100, p = 5, q = 5, rho = .5,
         b = 1, shift = 1, r.star = c(1, 3), sigma = c(1, 1),
         pr = c(.5, .5), seed = 1215)
K2ini <- initialize.para(K = 2, X = K2mod$X, Y = K2mod$Y,
         seed = 100)

#-----------------------------------------------------------#
# Simulation 2: Four Components Case
#-----------------------------------------------------------#
\donttest{
K4mod <- rrmix.sim.norm(K = 4, n = 600, p = 15, q = 15,
         rho = .5, b = 1, shift = 1, r.star = c(1, 1, 3, 3),
         sigma = c(1, 1, 1, 1), pr = c(.25, .25, .25, .25),
         seed = 1215)
K4ini <- initialize.para(K = 4, X = K4mod$X, Y = K4mod$Y,
         seed = 100)}
}
\references{
Kang, S., Chen, K., and Yao, W. (2022+). "Reduced rank estimation in mixtures
  of multivariate linear regression".
}
\seealso{
\code{\link{rrmix.sim.norm}}
}
\author{
Suyeon Kang, University of California, Riverside, \email{skang062@ucr.edu};
  Weixin Yao, University of California, Riverside, \email{weixin.yao@ucr.edu};
  Kun Chen, University of Connecticut, \email{kun.chen@uconn.edu}.
}
