% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refine_operations.R
\name{refine_operations}
\alias{refine_operations}
\title{Apply operations to OpenRefine project}
\usage{
refine_operations(
  project.name = NULL,
  project.id = NULL,
  verbose = FALSE,
  operations,
  ...
)
}
\arguments{
\item{project.name}{Name of project}

\item{project.id}{Unique identifier for project}

\item{verbose}{Logical specifying whether or not query result should be printed; default is \code{FALSE}}

\item{operations}{List of operations to perform}

\item{...}{Additional parameters to be inherited by \code{\link{refine_path}}; allows users to specify \code{host} and \code{port} arguments if the OpenRefine instance is running at a location other than \verb{http://127.0.0.1:3333}}
}
\value{
Operates as a side-effect passing operations to the OpenRefine instance. However, if \code{verbose=TRUE} then the function will return an object of the class "response".
}
\description{
This function allows users to pass arbitrary operations to an OpenRefine project via an API query to \verb{/command/core/apply-operations}. The operations to perform must be formatted as valid \code{JSON} and passed to this function as a \code{list} object.
}
\examples{
\dontrun{
fp <- system.file("extdata", "lateformeeting.csv", package = "rrefine")
refine_upload(fp, project.name = "lfm")

ops <-
   list(
       op = "core/text-transform",
       engineConfig = list(mode = "row-based", facets = list()),
       columnName = "was i on time for work",
       expression = "value.toUppercase()",
       onError = "set-to-blank")

refine_operations(project.name = "lfm", operations = list(ops), verbose = TRUE)
}

}
\references{
\url{https://docs.openrefine.org/technical-reference/openrefine-api#apply-operations}
}
