% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raw_GLIdiff.R
\name{raw_GLIdiff}
\alias{raw_GLIdiff}
\title{Convert z-scores back to raw diffusing capacity values using GLI (2017) equations}
\usage{
raw_GLIdiff(
  age,
  height,
  gender = 1,
  TLCO = NULL,
  KCO = NULL,
  VA = NULL,
  SI = TRUE
)
}
\arguments{
\item{age}{Age in years}

\item{height}{Height in meters}

\item{gender}{Gender (1 = male, 2 = female) or a factor with two levels (first = male). Default is 1.}

\item{TLCO}{Transfer factor of the lung for carbon monoxide (z-score)}

\item{KCO}{Transfer coefficient of the lung for carbon monoxide (z-score)}

\item{VA}{Alveolar volume (z-score)}

\item{SI}{(default TRUE) Use SI (mmol/min/kPa) or traditional (ml/min/mmHg) units?}
}
\value{
If only one diffusing capacity z-score argument is supplied, the function
returns a numeric vector. If more are supplied, the function returns 
a data.frame with the same number of columns.
}
\description{
This function takes z-scores based on the GLI (2017) equations, 
plus demographic data (age, height and gender), and converts them back
into absolute diffusing capacity measurements (TLCO, KCO and VA).
}
\details{
At least one of the diffusing capacity z-score arguments must be set (i.e. be
non-\code{NULL}). Arguments \code{age}, \code{height} and \code{gender} 
must be vectors of length equal to the length of the
z-score vector(s), or of length one, in which case their value is recycled.
If any input vector is not of equal length, the function stops with an error.
}
\examples{
# Random data, 4 patients, one z-score parameter supplied (TLCO)
raw_GLIdiff(age=seq(25,40,5), height=c(1.8, 1.9, 1.75, 1.85),
      gender=c(2,1,2,1), TLCO=c(-1.2, -1.9, 0, 0.5))

}
