% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/installConda.R
\name{installConda}
\alias{installConda}
\alias{installConda,character-method}
\alias{installConda,missingOrNULL-method}
\alias{installConda,Session-method}
\title{Installs Miniforge or Miniconda}
\usage{
installConda(session, software = "miniforge")

\S4method{installConda}{character}(session, software = "miniforge")

\S4method{installConda}{missingOrNULL}(session, software = "miniforge")

\S4method{installConda}{Session}(session, software = "miniforge")
}
\arguments{
\item{session}{\code{\link{Session-class}} object. If \code{NULL} (default),
\code{session()} will be used}

\item{software}{character. Whether to install the latest release of
"miniforge" (Default) or "miniconda".}
}
\value{
Invisibly returns \code{TRUE} upon success (i.e.successful
install) and \code{FALSE} upon failure.
}
\description{
This function installs the Miniforge or Miniconda package manager software
to the default installation path within the SyncroSim installation folder.
If you already have conda installed in the non-default location, you can
point SyncroSim towards that installation using the
\code{\link{condaFilepath}} function.
}
\examples{
\dontrun{
# Install miniforge for the default SyncroSim session
installConda()

# Install miniconda for the default SyncroSim session
installConda(software = "miniconda")
}

}
