% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/columns.R
\name{for_each_col}
\alias{for_each_col}
\title{Apply a column setter function to multiple columns}
\usage{
for_each_col(widget, columns = NULL, .f, ...)
}
\arguments{
\item{widget}{A \code{\link[=tabulator]{tabulator()}} HTML widget.}

\item{columns}{(character vector): The columns the column setter function (\code{.f}) is applied to.
If set to \code{NULL},  it is applied to all columns.}

\item{.f}{(function): The column setter function that updates the column settings.}

\item{...}{Arguments that are passed to \code{.f}.}
}
\value{
The updated \code{\link[=tabulator]{tabulator()}} HTML widget
}
\description{
Apply a column setter function to multiple columns
}
\examples{
numeric_cols <- c("Sepal_Length", "Sepal_Width", "Petal_Length", "Petal_Width")

tabulator(iris) |>
  for_each_col(numeric_cols, .f = set_header_filter, type = "number", func = "<=")
}
