% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabulator.R
\name{rtabulator-shiny}
\alias{rtabulator-shiny}
\alias{tabulatorOutput}
\alias{renderTabulator}
\title{Shiny bindings for rtabulator}
\usage{
tabulatorOutput(outputId, width = "100\%", height = "400px")

renderTabulator(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{output variable to read from}

\item{width, height}{Must be a valid CSS unit (like \code{'100\%'},
\code{'400px'}, \code{'auto'}) or a number, which will be coerced to a
string and have \code{'px'} appended.}

\item{expr}{An expression that generates a rtabulator}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
is useful if you want to save an expression in a variable.}
}
\value{
Components for use inside a Shiny app.
}
\description{
Output and render functions for using rtabulator within Shiny
applications and interactive Rmd documents.
}
