% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/columns.R
\name{set_formatter_datetime}
\alias{set_formatter_datetime}
\title{Set datetime formatter}
\usage{
set_formatter_datetime(
  widget,
  column,
  input_format = "yyyy-MM-dd hh:ss:mm",
  output_format = "yy/MM/dd",
  invalid_placeholder = "(invalid datetime)",
  timezone = NA,
  hoz_align = "left"
)
}
\arguments{
\item{widget}{A \code{\link[=tabulator]{tabulator()}} HTML widget.}

\item{column}{The name of the column the formatter is applied to.}

\item{input_format}{(character): The datetime input format.}

\item{output_format}{(character): The datetime output format.}

\item{invalid_placeholder}{(character): The value to be displayed
if an invalid datetime is provided.}

\item{timezone}{(character): The timezone of the datetime.}

\item{hoz_align}{(character): The horizontal alignment of the column.}
}
\value{
The updated \code{\link[=tabulator]{tabulator()}} HTML widget
}
\description{
Set datetime formatter
}
\details{
To use this formatter, you need to include
the \href{https://moment.github.io/luxon/}{luxon} HTML dependency with \code{tabulator(..., luxon = TRUE)}.
}
\examples{
data <- data.frame(
  Person = c("Franz", "Ferdinand"),
  Birthday = c(
    "2024-12-06 22:00:10",
    "2023-06-07 14:12:45"
  )
)

tabulator(data, luxon = TRUE) |>
  set_formatter_datetime("Birthday", output_format = "dd.MM.yyyy")
}
