% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/columns.R
\name{set_formatter_money}
\alias{set_formatter_money}
\title{Set money formatter}
\usage{
set_formatter_money(
  widget,
  column,
  decimal = c(",", "."),
  thousand = c(".", ","),
  symbol = "$",
  symbol_after = "p",
  negative_sign = "-",
  precision = FALSE,
  hoz_align = "left"
)
}
\arguments{
\item{widget}{A \code{\link[=tabulator]{tabulator()}} HTML widget.}

\item{column}{The name of the column the formatter is applied to.}

\item{decimal}{(character): Symbol to represent the decimal point.}

\item{thousand}{(character, bool): Symbol to represent the thousands separator.
Set to \code{FALSE} to disable the separator.}

\item{symbol}{(character): The currency symbol.}

\item{symbol_after}{(bool): Whether to put the symbol after the number.}

\item{negative_sign}{(character, bool): The sign to show in front of the number.
Set to \code{TRUE} causes negative numbers to be enclosed in brackets (123.45),
which is the standard style for negative numbers in accounting.}

\item{precision}{(integer, bool): The number of decimals to display.
Set to \code{FALSE} to display all decimals that are provided.}

\item{hoz_align}{(character): The horizontal alignment of the column.}
}
\value{
The updated \code{\link[=tabulator]{tabulator()}} HTML widget
}
\description{
Set money formatter
}
\examples{
data <- data.frame(
  Account_Number = c(
    123456,
    345667,
    234567,
    234566
  ),
  Account_Balance = c(100, -50, 200.30, -21.5)
)

tabulator(data) |>
  set_formatter_money(
    "Account_Balance",
    symbol = "\U20AC",
    symbol_after = FALSE,
    hoz_align = "right"
  )
}
