% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/columns.R
\name{set_formatter_progress}
\alias{set_formatter_progress}
\title{Set progress formatter}
\usage{
set_formatter_progress(
  widget,
  column,
  min = NA,
  max = NA,
  color = c("yellow", "orange", "red"),
  legend = NA,
  legend_color = "#000000",
  legend_align = c("center", "left", "right", "justify"),
  hoz_align = "left"
)
}
\arguments{
\item{widget}{A \code{\link[=tabulator]{tabulator()}} HTML widget.}

\item{column}{The name of the column the formatter is applied to.}

\item{min}{(numeric): The minimum value for progress bar.
If set to \code{NA}, the minimum value of the column is used.}

\item{max}{(numeric): The maximum value for progress bar.
If set to \code{NA}, the maximum value of the column is used.}

\item{color}{(character): Either a single color or a vector of colors}

\item{legend}{(character, \code{TRUE}, JavaScript function): If set to \code{TRUE},
the value of the cell is displayed. Set to \code{NA} to display no value at all.
Use \link[htmlwidgets]{JS} to pass a JavaScript function as legend.
In this case, the cell value is passed to the function as its first argument.}

\item{legend_color}{(character): The text color of the legend.}

\item{legend_align}{(character): The text alignment of the legend.}

\item{hoz_align}{(character): The horizontal alignment of the column.}
}
\value{
The updated \code{\link[=tabulator]{tabulator()}} HTML widget
}
\description{
Set progress formatter
}
\examples{
data <- data.frame(
  id = 1:6,
  value = c(10, 0, 100, 20, 40, 60),
  value2 = c(10, 0, 100, 20, 40, 60),
  value3 = c(10, 0, 100, 20, 40, 60)
)

js_func <- htmlwidgets::JS("(cellValue) => `${cellValue}\%`")

tabulator(data) |>
  set_formatter_progress("value") |>
  set_formatter_progress("value2", legend = TRUE, legend_align = "left") |>
  set_formatter_progress("value3", legend = js_func, legend_align = "right")
}
