% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/columns.R
\name{set_header_filter}
\alias{set_header_filter}
\title{Set header filter}
\usage{
set_header_filter(
  widget,
  column,
  type = c("input", "number", "list", "tickCross"),
  func = c("like", "=", ">", ">=", "<", "<="),
  values_lookup = TRUE,
  clearable = TRUE,
  placeholder = NULL
)
}
\arguments{
\item{widget}{A \code{\link[=tabulator]{tabulator()}} HTML widget.}

\item{column}{The name of the column the formatter is applied to.}

\item{type}{(character): The type of the filter.}

\item{func}{(character): The filter function.}

\item{values_lookup}{(bool): Whether to use unique column values for the list filter.}

\item{clearable}{(bool): Whether to display a cross to clear the filter.}

\item{placeholder}{(character): Text that is displayed when no filter is set.}
}
\value{
The updated \code{\link[=tabulator]{tabulator()}} HTML widget
}
\description{
Set header filter
}
\examples{
data <- data.frame(
  age = c(10, 20, 40),
  first_name = c("Franz", "Ferdinand", "Julia"),
  last_name = c("Young", "Bowie", "Blackey")
)

tabulator(data) |>
  set_header_filter("age", type = NULL, func = "<=", placeholder = "max age") |>
  set_header_filter("first_name", placeholder = "Fran") |>
  set_header_filter("last_name", type = "list")
}
