% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabulator_options.R
\name{set_options_group_by}
\alias{set_options_group_by}
\title{Set group by options}
\usage{
set_options_group_by(
  widget,
  group_by,
  group_start_open = TRUE,
  group_toggle_element = "header",
  ...
)
}
\arguments{
\item{widget}{A \code{\link[=tabulator]{tabulator()}} HTML widget.}

\item{group_by}{(character vector): Field to group rows by. Pass multiple values
for multi level grouping.}

\item{group_start_open}{(bool vector): Open state of groups when grouping is enabled.
The length of the vector depends on the number of levels set with \code{group_by}.}

\item{group_toggle_element}{(character, bool): One of \code{arrow} or \code{header}.
Set to \code{FALSE} to disable toggling at all.}

\item{...}{Further options.}
}
\value{
The updated \code{\link[=tabulator]{tabulator()}} HTML widget
}
\description{
Set group by options
}
\examples{
tabulator(iris) |>
  set_options_group_by("Species", group_start_open = FALSE)
}
