% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conditional_operator.R
\name{?}
\alias{?}
\title{Succinct conditional evaluation and assignment}
\usage{
lhs ? rhs
}
\arguments{
\item{lhs}{A logical expression, vector or matrix.}

\item{rhs}{A pair of values separated by a colon i.e. \code{value_if_true : value_if_false}.}
}
\value{
One of the values in \code{rhs}, depending on the truthiness of \code{lhs}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{?} is an in-line if/else operator
}
\details{
The syntax for ? is as follows:

\code{condition ? value_if_true : value_if_false}

The condition is evaluated TRUE or FALSE as a Boolean expression.
On the basis of the evaluation of the Boolean condition, the entire expression
returns \code{value_if_true} if \code{condition} is true, but \code{value_if_false} otherwise.
In the case where the condition is a vector/matrix of Boolean values, the
function returns a vector/matrix where each element is either \code{value_if_true}
or \code{value_if_false} based on the truthiness of the elements of the object on
the left-hand side. In these cases the behaviour of \verb{?} mimics \link[base]{ifelse}.

Who has time for if/else?
}
\examples{
# Conditional evaluation
4 > 3 ? "it_was_true":"it_was_false"
# > "it_was_true"

FALSE ? "it_was_true":"it_was_false"
# > "it_was_false"

# Vectorised evaluation
c(4, 2) < 3 ? "it_was_true":"it_was_false"
# > "it_was_false" "it_was_true"

# Conditional assignment with `<-`
x <- 4 > 3 ? "it_was_true":"it_was_false"
x
# > "it_was_true"

# Conditional assignment with `=`
y <- 3 > 4 ? "it_was_true":"it_was_false"
y
# > "it_was_false"

# Chaining `?` statements
z <- FALSE ? "true":(FALSE ? "false,true":(TRUE ? "false,false,true":"all false"))
z
# > "false,false,true"
}
