% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setupDataset.R
\name{setupDataset}
\alias{setupDataset}
\title{Setup datasets loaded from the living conditions survey}
\usage{
setupDataset(dataset, country = "ES", region = NULL, s = NULL,
  deflator = NULL, pppr = NULL)
}
\arguments{
\item{dataset}{a data.frame containing variables in the EU-SILC microdata format.}

\item{country}{a character string specifying the country whose data will be considered.}

\item{region}{a character/vector string specifying the region(s) of the country whose data will be considered. The default (NULL) considers all regions in the country.}

\item{s}{a numeric value between 0 and 1 specifying the equivalence scale to be used to obtain the equivalised disposable income. The default (NULL) considers the standard modified OECD scale.}

\item{deflator}{numeric; a number to be used as a deflator. The default (NULL) will not apply any deflation.}

\item{pppr}{the purchasing power parity rate (PPPR) will be used. Default is NULL.}
}
\value{
A data.frame with the following variables:
\itemize{
 \item DB010 a numeric vector containing the year of the survey.
 \item DB020 a factor with one level which is the country considered.
 \item DB040 a factor with as many levels as there are regions in the country.
 \item DB090 a numeric vector containing information about household cross-sectional weight.
 \item HX040 an integer vector containing information about households size.
 \item HX050 a numeric vector containing information about the equivalised household size. The scale employed is the modified OECD scale.
 \item HX090 a numeric vector containing information about equivalised disposable income (with the modified OECD scale).
 \item ipuc a numeric vector containing the income per unit of consumption. This variable takes into account the value assigned to s and pppr (if they are not NULL).
}
}
\description{
Extracts and transforms variables taken directly from the EU-SILC survey.
}
\details{
We obtain the equivalised disposable income with the equivalence
scale of Buhmann et al. (1988) by assigning a numeric value between 0 and 1
to argument s. The parameter s is called elasticity of equivalence.

The purchasing power parity exchange rate is useful for making comparisons between countries.
}
\examples{
data(eusilc2)
ATdataset <- setupDataset(eusilc2, country = "AT")
str(ATdataset)

}
\references{
B. Buhmann et al. (1988) Equivalence scales, well-being, inequality and poverty: sensitivity estimates across ten countries using the Luxembourg Income Study (LIS) database, Review of Income and Wealth, 34, 115--142.
}
\seealso{
loadEUSILC, loadLCS
}
\author{
A. Berihuete, C.D. Ramos and M.A. Sordo
}
