% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtmsBrukerBAFReader.R
\name{getSpectrum.rtmsBrukerBAFReader}
\alias{getSpectrum.rtmsBrukerBAFReader}
\alias{getBrukerBAFSpectrum}
\title{Extract a spectrum from a Bruker BAF directory}
\usage{
\method{getSpectrum}{rtmsBrukerBAFReader}(x, ...)

getBrukerBAFSpectrum(reader)
}
\arguments{
\item{x}{The BAF reader object}

\item{...}{Additional parameters}

\item{reader}{An RTMS reader object of class \code{rtmsBrukerBAFReader}}
}
\value{
An RTMS spectrum object of class \code{rtmsSpectrum}
}
\description{
Extracts an RTMS spectrum object (of class \code{rtmsSpectrum}) from a single
acquisition Bruker BAF directory opened using an RTMS reader object (of
class \code{rtmsBrukerBAFReader}).  Because a BAF directory only contains one
spectrum, no additional parameters are needed to specify the spectrum to be
extracted.
}
\section{Functions}{
\itemize{
\item \code{getSpectrum(rtmsBrukerBAFReader)}: The S3 method \code{getSpectrum} for objects
of class \code{rtmsBrukerBAFReader}; calls \code{getBrukerBAFSpectrum}

}}
