% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtmsBrukerMCFReader.R
\name{getBrukerMCFMetadata}
\alias{getBrukerMCFMetadata}
\title{Retrieve specific metadata values from a Bruker BAF file}
\usage{
getBrukerMCFMetadata(reader, names, index)
}
\arguments{
\item{reader}{An RTMS reader object of class \code{rtmsBrukerMCFReader}}

\item{names}{A character vector of metadata names}

\item{index}{A single numeric index specifying which acquisition the sample
set should be extracted from}
}
\value{
A named list of values corresponding to the metadata values
specified.  All values will be returned as a string, including numeric
quantities (with units if appropriate).
}
\description{
Retrieves a list of specific metadata values (including instrument data,
acquisition parameters, processing and analysis directives, etc.) for a
specific acquisition from from a Bruker multi-acquisition BAF directory
(represented by an \code{rtmsBrukerBAFReader} object).
}
