% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtmsPlotting.R
\name{plotRtmsSampleSet}
\alias{plotRtmsSampleSet}
\title{Plot an RTMS sample set object}
\usage{
plotRtmsSampleSet(sampleset, usePeakNames = TRUE, freey = TRUE)
}
\arguments{
\item{sampleset}{An object of class \code{rtmsSampleSet}.}

\item{usePeakNames}{If the list of peaks used to create the sample set was a
named list, then setting this to TRUE (the default) will use those names to
label the facets of the plotted sample set. If set to FALSE, the facets will
be labelled with the m/z values of each peak.  This parameter will be ignored
if the peaks are unnamed.}

\item{freey}{If TRUE (the default) the y-axes of each sample and peak's facet
will beallowed to vary freely, so different facets will be plotted on
different scales.  Setting this to FALSE will fix all peaks and samples
on the same y-axis scale.}
}
\value{
A \code{ggplot} object depicting the RTMS sample set.
}
\description{
\code{plotRtmsSampleSet()} takes an RTMS sample set object and produces a \code{ggplot}
object depicting all extracted peaks, and their context windows if included.
}
\examples{
peaks <- rtmsPeakList(c(1516.83,1530.84),peakWidth=0.2,windowWidth = c(5,10))
names(peaks) <- c("Product","Substrate")
sample <- getSample(exampleSpectrum,peaks)
sampleSet <- rep(sample,3)
names(sampleSet) <- c("A","B","C")

plot1 <- plotRtmsSampleSet(sampleSet)
plot2 <- plotRtmsSampleSet(sampleSet,freey=FALSE) + ggplot2::theme_bw()
}
