% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtmsPlotting.R
\name{plotRtmsSpectrum}
\alias{plotRtmsSpectrum}
\title{Plot an RTMS spectrum object}
\usage{
plotRtmsSpectrum(spectrum, limits = NULL)
}
\arguments{
\item{spectrum}{An object of class \code{rtmsSpectrum}.}

\item{limits}{An optional parameter to control the bounds of the m/z x axis.
If set to NULL, the default, the full spectrum will be plotted.  Otherwise,
\code{limits} should be a two element numeric vector; if one element is \code{NA}, then
only the other boundary will be enforced on the x-axis.}
}
\value{
A \code{ggplot} object depicting the RTMS spectrum.
}
\description{
\code{plotRtmsSpectrum()} takes an RTMS spectrum object and produces a \code{ggplot}
object depicting the spectrum
}
\details{
Unlike a sample object, an RTMS spectrum is actually quite simple; just a
vector of m/z values and vector of intensities.  Ordinarily, this could be
done using standard \code{ggplot2} functions, such as geom_line.  However, mass
spectra can often be quite large (on the order of millions of measurements),
and sending all that data to be plotted can be computationally intractable.
\code{plotRtmsSpectrum()} therefore selects a subset of up to 10000 m/z-intensity
pairs from the original spectrum to produce a representative plot without
rendering millions of points.  Any points that are sufficiently larger than
their local surroundings (including all relevant peaks) will be included in
this subset, as well as a random sampling of points closer to the baseline.
This ensures that the peaks plotted will always be present.  However, there
will be slight differences from one plot to the next in terms of baseline
points plotted.  This can be eliminated by fixing the random seed using
\code{set.seed} before plotting.

We also strongly discourage using \code{xlim} or seetting the x-coordinate
boundaries using standard \code{ggplot2} methods, as these will only be applied
after the data has been down-sampled.  If you would like to plot a particular
subset of the spectrum, it is recommended that you use the \code{limits} parameter
of this function instead.
}
\examples{
plot1 <- plotRtmsSpectrum(exampleSpectrum)
plot2 <- plotRtmsSpectrum(exampleSpectrum,limits=c(1500,1550)) +
				ggplot2::geom_vline(xintercept=c(1516.83,1530.84),
									colour="red",linetype=2)
}
